/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntDocument
extends PlainDocument {
    private long min;
    private long max;

    public IntDocument(long minValue, long maxValue) {
        this.min = minValue;
        this.max = maxValue;
    }

    public IntDocument() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        String originalInput = null;
        if (this.getLength() == 0) {
            originalInput = str;
        } else {
            StringBuffer currentBuffer = new StringBuffer(super.getText(0, this.getLength()));
            currentBuffer.insert(offs, str);
            originalInput = currentBuffer.toString().trim();
        }
        try {
            this.processOriginalInput(originalInput);
            super.insertString(offs, str.trim(), a);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void processOriginalInput(String originalInput) throws NumberFormatException {
        long value = 0L;
        int length = originalInput.length();
        if (length == 0) {
            return;
        }
        if (this.min < 0L && length == 1 && originalInput.startsWith("-") && this.min < 0L) {
            return;
        }
        value = Long.parseLong(originalInput);
        if (value <= this.max && (this.min < 0L && value >= this.min || this.min >= 0L)) {
            return;
        }
        throw new NumberFormatException(String.valueOf(originalInput) + " \u4e0d\u5728\u8303\u56f4 [" + this.min + "," + this.max + "]\u4e4b\u5185.");
    }

    public void setMin(long newMin) {
        this.min = newMin;
    }

    public long getMin() {
        return this.min;
    }

    public void setMax(long newMax) {
        this.max = newMax;
    }

    public long getMax() {
        return this.max;
    }
}

