/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.widget.ELineNumTable;
import com.eva.epc.widget.ETableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;

public class ColorableTableX
extends ELineNumTable {
    protected Vector rowWillColored = null;
    protected Vector colWillColored = null;
    protected Vector cellWillColored = null;
    protected Color rowWillColoredColor = new Color(255, 177, 177);
    protected Color colWillColoredColor = new Color(255, 177, 255);
    protected Color cellWillColoredColor = new Color(177, 255, 255);
    protected Color notColoredColor = super.getBackground();
    public static final int COLORED_ROW = 0;
    public static final int COLORED_COLUMN = 1;
    public static final int COLORED_CELL = 2;
    public static final int COLORED_ROW_COLUMN = 3;
    public static final int COLORED_ROW_CELL = 4;
    public static final int COLORED_COLUMN_CELL = 5;
    public static final int COLORED_ROW_COLUMN_CELL = 6;
    private int coloredField = 0;

    public ColorableTableX(ETableModel model, int coloredField) {
        super(model);
        this.coloredField = coloredField;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        this.colored(renderer, false, 0);
        switch (this.coloredField) {
            case 0: {
                if (!this.rowWillColored.contains(new Integer(row))) break;
                this.colored(renderer, true, 0);
                break;
            }
            case 1: {
                if (!this.colWillColored.contains(new Integer(column))) break;
                this.colored(renderer, true, 1);
                break;
            }
            case 2: {
                if (!this.willColored(row, column)) break;
                this.colored(renderer, true, 2);
                break;
            }
            case 3: {
                if (this.colWillColored.contains(new Integer(column))) {
                    this.colored(renderer, true, 1);
                    break;
                }
                if (!this.rowWillColored.contains(new Integer(row))) break;
                this.colored(renderer, true, 0);
                break;
            }
            case 4: {
                if (this.willColored(row, column)) {
                    this.colored(renderer, true, 2);
                    break;
                }
                if (!this.rowWillColored.contains(new Integer(row))) break;
                this.colored(renderer, true, 0);
                break;
            }
            case 5: {
                if (this.willColored(row, column)) {
                    this.colored(renderer, true, 2);
                    break;
                }
                if (!this.colWillColored.contains(new Integer(column))) break;
                this.colored(renderer, true, 1);
                break;
            }
            case 6: {
                if (this.willColored(row, column)) {
                    this.colored(renderer, true, 2);
                    break;
                }
                if (this.colWillColored.contains(new Integer(column))) {
                    this.colored(renderer, true, 1);
                    break;
                }
                if (!this.rowWillColored.contains(new Integer(row))) break;
                this.colored(renderer, true, 0);
            }
        }
        return renderer;
    }

    protected void colored(TableCellRenderer renderer, boolean needColored, int type) {
        if (needColored) {
            ((Component)((Object)renderer)).setBackground(type == 0 ? this.rowWillColoredColor : (type == 1 ? this.colWillColoredColor : this.cellWillColoredColor));
        } else {
            ((Component)((Object)renderer)).setBackground(this.notColoredColor);
        }
    }

    protected boolean willColored(int row, int column) {
        boolean is = false;
        if (this.cellWillColored instanceof Vector) {
            Vector willColoredRow = (Vector)this.cellWillColored.get(row);
            is = willColoredRow.contains(new Integer(column));
        }
        return is;
    }

    public void setCellWillColored(Vector cellWillColored) {
        this.cellWillColored = cellWillColored;
        if (cellWillColored.size() > 0) {
            this.getTableHeader().setReorderingAllowed(false);
            this.setSortable(false);
        }
    }

    public void setCellWillColoredColor(Color cellWillColoredColor) {
        this.cellWillColoredColor = cellWillColoredColor;
    }

    public void setColWillColored(Vector colWillColored) {
        this.colWillColored = colWillColored;
        if (colWillColored.size() > 0) {
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    public void setColWillColoredColor(Color colWillColoredColor) {
        this.colWillColoredColor = colWillColoredColor;
    }

    public void setRowWillColored(Vector rowWillColored) {
        this.rowWillColored = rowWillColored;
    }

    public void setRowWillColoredColors(Color rowWillColoredColor) {
        this.rowWillColoredColor = rowWillColoredColor;
    }

    public void setNotColoredColor(Color notColoredColor) {
        this.notColoredColor = notColoredColor;
    }

    public Vector getCellWillColored() {
        return this.cellWillColored;
    }

    public Color getCellWillColoredColor() {
        return this.cellWillColoredColor;
    }

    public Vector getColWillColored() {
        return this.colWillColored;
    }

    public Color getColWillColoredColor() {
        return this.colWillColoredColor;
    }

    public Vector getRowWillColored() {
        return this.rowWillColored;
    }

    public Color getRowWillColoredColor() {
        return this.rowWillColoredColor;
    }

    public Color getNotColoredColor() {
        return this.notColoredColor;
    }
}

