/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.plaf;

import com.eva.epc.lnf.nimbuslike.NLComboBoxUI;
import com.eva.epc.widget.ESearchableField;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ESearchableComboBoxUI
extends NLComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new ESearchableComboBoxUI();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap am = this.comboBox.getActionMap();
        if (am != null && !(am.get("selectNext") instanceof ScrollAction)) {
            am.put("selectPrevious", new ScrollAction(true));
            am.put("selectNext", new ScrollAction(false));
        }
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (this.editor instanceof ESearchableField) {
            ESearchableField txtField = (ESearchableField)this.editor;
            if (!(txtField instanceof ESearchableField) || !txtField.getSearcheResultPopupMenu().isVisible()) {
                super.setPopupVisible(c, v);
                return;
            }
        } else if (this.isPopupVisible(c)) {
            super.setPopupVisible(c, v);
            return;
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        private boolean pageDown;

        public ScrollAction(boolean upward) {
            this.pageDown = upward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                ESearchableComboBoxUI ui = (ESearchableComboBoxUI)comboBox.getUI();
                if (!comboBox.isEditable() || ui.isPopupVisible(comboBox)) {
                    if (this.pageDown) {
                        ui.selectPreviousPossibleValue();
                    } else {
                        ui.selectNextPossibleValue();
                    }
                } else {
                    ESearchableField txtField;
                    if (ui.editor instanceof ESearchableField && (txtField = (ESearchableField)ui.editor).getSearcheResultPopupMenu().isVisible()) {
                        return;
                    }
                    ui.setPopupVisible(comboBox, true);
                }
            }
        }
    }
}

