/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.border;

import com.eva.epc.widget.util.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ETitledLine
extends JComponent {
    private String title = null;
    private Color titleColor = new Color(102, 102, 102);
    private Font titleFont = new Font("\u5b8b\u4f53", 1, 12);
    private int bottomLine1Width = -1;
    private int bottomLine1Height = 4;
    private Color bottomLine1Color = new Color(144, 201, 0);
    private int bottomLine2EntityOfStroke = 1;
    private int bottomLine2SpacingOfStroke = 1;
    private Color bottomLine2Color = new Color(180, 180, 180);

    public ETitledLine() {
    }

    public ETitledLine(String title) {
        this.title = title;
        this.refreshBottomLine1Width();
    }

    private void refreshBottomLine1Width() {
        this.bottomLine1Width = this.needDrawTitle() ? SwingUtils.getStrPixWidth(this.titleFont, this.getTitle()) : 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Border b = this.getBorder();
        Insets its = null;
        if (b != null) {
            its = b.getBorderInsets(this);
        }
        return new Dimension(100 + (its != null ? its.left + its.right : 0), (this.needDrawTitle() ? SwingUtils.getStrPixHeight(this.titleFont) : 0) + this.bottomLine1Height + (its != null ? its.top + its.bottom : 0));
    }

    @Override
    public void paint(Graphics g) {
        int startX;
        Graphics2D g2d = (Graphics2D)g;
        Border b = this.getBorder();
        Insets its = null;
        if (b != null) {
            its = b.getBorderInsets(this);
        }
        int y = its != null ? its.top : 0;
        int x = its != null ? its.left : 0;
        int titleWidth = this.needDrawTitle() ? g2d.getFontMetrics().stringWidth(this.title) : 0;
        int n = startX = titleWidth == 0 ? 0 : titleWidth + 5;
        if (this.needDrawTitle()) {
            g2d.setFont(this.titleFont);
            g2d.setColor(new Color(255, 255, 255));
            g2d.drawString(this.title, x, y + g2d.getFontMetrics().getAscent() - 1);
            g2d.setColor(this.titleColor);
            g2d.drawString(this.title, x, y + g2d.getFontMetrics().getAscent());
        }
        int n2 = this.needDrawTitle() ? SwingUtils.getStrPixHeight(this.titleFont) : 0;
        g2d.setColor(this.bottomLine1Color);
        g2d.fillRoundRect(x, y += n2, this.bottomLine1Width, this.bottomLine1Height, 0, 0);
        Stroke oldStroke = g2d.getStroke();
        BasicStroke sroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{this.bottomLine2EntityOfStroke, this.bottomLine2SpacingOfStroke}, 0.0f);
        g2d.setStroke(sroke);
        g2d.setColor(this.bottomLine2Color);
        g2d.drawLine(x + this.bottomLine1Width + 1, y += this.bottomLine1Height - 1, this.getWidth(), y);
        g2d.setStroke(oldStroke);
    }

    public boolean needDrawTitle() {
        return this.title != null;
    }

    public String getTitle() {
        return this.title;
    }

    public ETitledLine setTitle(String title) {
        this.title = title;
        this.refreshBottomLine1Width();
        return this;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public ETitledLine setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public ETitledLine setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        return this;
    }

    public int getBottomLine1Width() {
        return this.bottomLine1Width;
    }

    public ETitledLine setBottomLine1Width(int bottomLine1Width) {
        this.bottomLine1Width = bottomLine1Width;
        return this;
    }

    public int getBottomLine1Height() {
        return this.bottomLine1Height;
    }

    public ETitledLine setBottomLine1Height(int bottomLine1Height) {
        this.bottomLine1Height = bottomLine1Height;
        return this;
    }

    public Color getBottomLine1Color() {
        return this.bottomLine1Color;
    }

    public ETitledLine setBottomLine1Color(Color bottomLine1Color) {
        this.bottomLine1Color = bottomLine1Color;
        return this;
    }

    public int getBottomLine2EntityOfStroke() {
        return this.bottomLine2EntityOfStroke;
    }

    public ETitledLine setBottomLine2EntityOfStroke(int bottomLine2EntityOfStroke) {
        this.bottomLine2EntityOfStroke = bottomLine2EntityOfStroke;
        return this;
    }

    public int getBottomLine2SpacingOfStroke() {
        return this.bottomLine2SpacingOfStroke;
    }

    public ETitledLine setBottomLine2SpacingOfStroke(int bottomLine2SpacingOfStroke) {
        this.bottomLine2SpacingOfStroke = bottomLine2SpacingOfStroke;
        return this;
    }

    public Color getBottomLine2Color() {
        return this.bottomLine2Color;
    }

    public ETitledLine setBottomLine2Color(Color bottomLine2Color) {
        this.bottomLine2Color = bottomLine2Color;
        return this;
    }
}

