/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.bind;

import com.eva.epc.common.util.SimpleLogger;
import com.eva.epc.widget.bind.TextComponentBinder;
import com.eva.epc.widget.util.SwingUtils;
import java.math.BigDecimal;
import java.util.Observer;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableToTextBindListener
implements TableModelListener {
    private int[] columnsWillBeSumed;
    private JTextField resultDestField;
    private TextComponentBinder bindedCalculator;
    private int checkCol;
    private Observer observer = null;

    public TableToTextBindListener(int columnsWillBeSumed, JTextField resultDestField, int checkColumn) {
        this(new int[]{columnsWillBeSumed}, resultDestField, checkColumn);
    }

    public TableToTextBindListener(int[] columnsWillBeSumed, JTextField resultDestField, int checkColumn) {
        this.columnsWillBeSumed = columnsWillBeSumed;
        this.resultDestField = resultDestField;
        this.checkCol = checkColumn;
    }

    public void setObs(Observer o) {
        this.observer = o;
    }

    public void setBindedCalculator(TextComponentBinder bindedCalculator) {
        this.bindedCalculator = bindedCalculator;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tmWillBeSumed = (TableModel)e.getSource();
        SimpleLogger.d((String)("ColumnCalculator tableChanged checkCol =" + this.checkCol));
        BigDecimal value = SwingUtils.sumTableColumn(tmWillBeSumed, this.checkCol, this.columnsWillBeSumed);
        this.resultDestField.setText(value.toString());
        if (this.observer != null) {
            this.observer.update(null, this.resultDestField.getText());
        }
        if (this.bindedCalculator != null) {
            this.bindedCalculator.calculate();
        }
    }
}

