/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.util.ColorHelper;
import com.eva.epc.widget.util.GraphicHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;

public class InfiniteProgressPanelX
extends Box
implements ActionListener {
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.5f;
    protected RenderingHints hints = null;
    private boolean cancelOnDoubleClick = true;
    private Timer animation = null;
    private boolean rampUp = true;
    private long start = 0L;
    private JLabel busyLabel = null;
    private JLabel txtLabel = null;
    public static final Color txtDefaultColor = new JLabel().getForeground();
    private Box content = Box.createHorizontalBox();
    private ImageIcon dynamicIcon = IconFactory.getInstance().getInfiniteProgressGif();

    public InfiniteProgressPanelX() {
        super(0);
        this.init();
    }

    protected void init() {
        this.setOpaque(false);
        this.txtLabel = new JLabel();
        this.txtLabel.setFont(new Font("\u5b8b\u4f53", 1, 14));
        this.txtLabel.setForeground(ColorHelper.DARK_GRAY1_LIKE_APPLE.brighter());
        this.busyLabel = new JLabel();
        this.busyLabel.setForeground(ColorHelper.DARK_GRAY1_LIKE_APPLE.brighter());
        this.busyLabel.setFont(new Font("\u5b8b\u4f53", 1, 14));
        this.content.add(this.busyLabel);
        this.content.add(this.txtLabel);
        this.add(Box.createHorizontalGlue());
        this.add(this.content);
        this.add(Box.createHorizontalGlue());
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setText("\u6570\u636e\u6b63\u5728\u83b7\u53d6\u4e2d\uff0c\u8bf7\u7a0d\u5019 ...");
        this.setToolTipText("\u8bf7\u7b49\u5f85...");
        this.addMouseClickListener(this);
        this.addMouseClickListener(this.busyLabel);
        this.addMouseClickListener(this.txtLabel);
    }

    private void addMouseClickListener(JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && InfiniteProgressPanelX.this.cancelOnDoubleClick) {
                    InfiniteProgressPanelX.this.setText("\u9000\u51fa\u8fdb\u5ea6\u663e\u793a...");
                    InfiniteProgressPanelX.this.stop();
                }
            }
        });
    }

    private void cancelAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
        this.setVisible(true);
        if (this.rampUp) {
            this.alphaLevel = (int)(255L * (System.currentTimeMillis() - this.start) / (long)(this.rampDelay == 0 ? 500 : this.rampDelay));
            if (this.alphaLevel >= 255) {
                this.cancelAnimation();
                this.alphaLevel = 255;
                this.busyLabel.setIcon(this.dynamicIcon);
                this.txtLabel.setForeground(txtDefaultColor);
            }
        } else {
            this.busyLabel.setIcon(null);
            this.alphaLevel = (int)(255.0 - (double)(255L * (System.currentTimeMillis() - this.start)) / (this.rampDelay == 0 ? 500.0 : (double)this.rampDelay * 1.5));
            if (this.alphaLevel <= 0) {
                this.cancelAnimation();
                this.alphaLevel = 0;
                this.repaint();
                this.setVisible(false);
                this.txtLabel.setForeground(txtDefaultColor);
            }
        }
    }

    public void start() {
        this.cancelAnimation();
        this.animation = new Timer(10, this);
        this.alphaLevel = 0;
        this.start = System.currentTimeMillis();
        this.rampUp = true;
        this.animation.start();
    }

    public void stop() {
        this.cancelAnimation();
        this.alphaLevel = 255;
        this.start = System.currentTimeMillis();
        this.rampUp = false;
        this.animation = new Timer(10, this);
        this.animation.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.hints);
        Paint oldp = g2.getPaint();
        GraphicHandler.fillCrystalRoundRec(g2, new Color(255, 255, 255, 60), 0, 0, this.getWidth(), this.getHeight(), 0);
        Dimension d = this.content.getSize();
        int delta = 30;
        int arc = 15;
        Point busyLabelP = this.content.getLocation();
        int X = (int)busyLabelP.getX() - delta;
        int Y = (int)busyLabelP.getY() - delta;
        int W = (int)d.getWidth() + delta * 2;
        int H = (int)d.getHeight() + delta * 2;
        Color baseColor = new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield));
        GraphicHandler.fillCrystalRoundRec(g2, baseColor, X, Y, W, H, arc);
        Stroke oldStroke = g2.getStroke();
        float lineWidth = 0.5f;
        BasicStroke bs = new BasicStroke(lineWidth);
        g2.setStroke(bs);
        g2.setColor(new Color(220, 220, 220, 200));
        g2.draw(new RoundRectangle2D.Double(X, Y, W, H, arc, arc));
        g2.setColor(new Color(255, 255, 255, 200));
        g2.draw(new RoundRectangle2D.Double((float)X + lineWidth, (float)Y + lineWidth, (float)W - lineWidth * 2.0f, (float)H - lineWidth * 2.0f, arc, arc));
        g2.setColor(new Color(240, 240, 240, 100));
        g2.draw(new RoundRectangle2D.Double((float)X + lineWidth * 2.0f, (float)Y + lineWidth * 2.0f, (float)W - lineWidth * 2.0f, (float)H - lineWidth * 3.0f, arc, arc));
        g2.setStroke(oldStroke);
    }

    public boolean isCancelOnDoubleClick() {
        return this.cancelOnDoubleClick;
    }

    public void setCancelOnDoubleClick(boolean cancelOnDoubleClick) {
        this.cancelOnDoubleClick = cancelOnDoubleClick;
    }

    public void setText(String text) {
        this.txtLabel.setText(text);
        this.txtLabel.repaint();
    }

    public String getText() {
        return this.txtLabel.getText();
    }

    public Color getTxtColor() {
        return this.txtLabel.getForeground();
    }

    public void setTxtColor(Color txtColor) {
        if (txtColor != null) {
            this.txtLabel.setForeground(txtColor);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.busyLabel.setToolTipText(text);
        this.txtLabel.setToolTipText(text);
        super.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.busyLabel.getToolTipText();
    }

    public ImageIcon getDynamicIcon() {
        return this.dynamicIcon;
    }

    public void setDynamicIcon(ImageIcon dynamicIcon) {
        this.dynamicIcon = dynamicIcon;
    }

    public static InfiniteProgressPanelX addInfiniteProgress(RootPaneContainer willBeAddProgress) {
        return InfiniteProgressPanelX.addInfiniteProgress(willBeAddProgress, false);
    }

    public static InfiniteProgressPanelX addInfiniteProgress(RootPaneContainer willBeAddProgress, boolean cancelOnDoubleClick) {
        InfiniteProgressPanelX glassPane = new InfiniteProgressPanelX();
        willBeAddProgress.setGlassPane(glassPane);
        glassPane.setCancelOnDoubleClick(cancelOnDoubleClick);
        return glassPane;
    }
}

