/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.common.util.MapNoHash;
import com.eva.epc.common.util.SimpleLogger;
import com.eva.epc.widget.border.EDashedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ERender<V, K>
extends DefaultTableCellRenderer
implements ListCellRenderer {
    protected Color userBg;
    protected Color userFg;
    private MapNoHash<Object, Object> idAndNames = new MapNoHash();
    protected static Border defaultNoFocusBorde_List = new EDashedBorder(new Color(238, 238, 238), 1, 0, false, false, true, false);
    protected static Border defaultNoFocusBorde_Table = new EmptyBorder(1, 1, 1, 1);
    public static int itemSelectedArcWidth = 0;

    public ERender() {
    }

    public ERender(Object[] ids, Object[] names) {
        this.setIdAndNames(ids, names);
    }

    public ERender(Object[][] idAndNames) {
        Object[] ids = new Object[idAndNames.length];
        Object[] names = new Object[idAndNames.length];
        int i = 0;
        while (i < idAndNames.length) {
            ids[i] = idAndNames[i][0];
            names[i] = idAndNames[i][1];
            ++i;
        }
        this.setIdAndNames(ids, names);
    }

    public ERender(IdName[] idAndNames) {
        Object[] ids = new Object[idAndNames.length];
        Object[] names = new Object[idAndNames.length];
        int i = 0;
        while (i < idAndNames.length) {
            ids[i] = idAndNames[i].getId();
            names[i] = idAndNames[i].getName();
            ++i;
        }
        this.setIdAndNames(ids, names);
    }

    public ERender(Vector<Vector> idAndNames) {
        this(CommonUtils.to2DArray(idAndNames));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Insets comboBoxCellMargin = UIManager.getInsets("EComboBoxCell.margin");
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            if (itemSelectedArcWidth > 0) {
                this.setBorder(BorderFactory.createCompoundBorder(new EDashedBorder(new Color(234, 197, 60), 1, 1, true, true, true, false), new EmptyBorder(comboBoxCellMargin)));
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(new EDashedBorder(new Color(234, 197, 60), 1, 1, true, true, true, false), new EmptyBorder(comboBoxCellMargin)));
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setBorder(BorderFactory.createCompoundBorder(defaultNoFocusBorde_List, new EmptyBorder(comboBoxCellMargin)));
        }
        this.setFont(list.getFont());
        this.setValue(value);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.userFg != null ? this.userFg : table.getForeground());
            super.setBackground(this.userBg != null ? this.userBg : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(defaultNoFocusBorde_Table);
        }
        this.setValue(value);
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    public void setIdAndNames(Object[] ids, Object[] names) {
        if (ids.length != names.length) {
            SimpleLogger.w((String)"id\u548cname\u6570\u7ec4\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        int i = 0;
        while (i < ids.length) {
            this.addIdName(ids[i], names[i]);
            ++i;
        }
    }

    public Object[] getIds() {
        return this.idAndNames.keys().toArray();
    }

    public ArrayList getIds2() {
        return this.idAndNames.keys();
    }

    public Object[] getNames() {
        return this.idAndNames.elements().toArray();
    }

    public ArrayList getNames2() {
        return this.idAndNames.elements();
    }

    public MapNoHash<Object, Object> getIdAndNames() {
        return this.idAndNames;
    }

    public void setIdAndNames(MapNoHash<Object, Object> idAndNames) {
        this.idAndNames = idAndNames;
    }

    public IdName[] getIdAndNames2() {
        IdName[] ins = null;
        ArrayList keys = this.idAndNames.keys();
        int i = 0;
        while (i < keys.size()) {
            if (ins == null) {
                ins = new IdName[this.idAndNames.size()];
            }
            Object k = keys.get(i);
            ins[i] = new IdName(k, this.idAndNames.get(k));
            ++i;
        }
        return ins;
    }

    public void setIdAndNames2(IdName[] ins) {
        if (ins != null) {
            int i = 0;
            while (i < ins.length) {
                this.addIdName(ins[i]);
                ++i;
            }
        }
    }

    @Override
    protected void setValue(Object value) {
        this.setValueImpl(value, this.getNameById(value));
    }

    protected void setValueImpl(Object id, Object name) {
        if (name instanceof Icon) {
            this.setIcon((Icon)name);
            super.setValue(null);
        } else if (name instanceof ERenderDTO) {
            ERenderDTO dto = (ERenderDTO)name;
            super.setValue(dto.getName());
            this.setIcon(dto.getShowImage());
        } else {
            super.setValue(name);
            this.setIcon(null);
        }
    }

    public Object getNameById(Object id) {
        Object name = null;
        if (id != null) {
            name = this.idAndNames.get(id);
        }
        return name == null ? id : name;
    }

    protected Object getIdByName(Object name) {
        if (name != null) {
            ArrayList kes = this.idAndNames.keys();
            int i = 0;
            while (i < kes.size()) {
                Object key = kes.get(i);
                Object value = this.idAndNames.get(key);
                if (value.equals(name)) {
                    return key;
                }
                ++i;
            }
        }
        return null;
    }

    public void addIdName(IdName idName) {
        this.addIdName(idName.getId(), idName.getName());
    }

    public ERender addIdName(Object id, Object name) {
        this.idAndNames.put(id, name);
        return this;
    }

    public static int getItemSelectedArcWidth() {
        return itemSelectedArcWidth;
    }

    public static void setItemSelectedArcWidth(int itemSelectedArcWidth) {
        ERender.itemSelectedArcWidth = itemSelectedArcWidth;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.userBg = c;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.userFg = c;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (CommonUtils.isStringEmpty((String)this.getText())) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public static class ERenderDTO {
        private Object name;
        private Icon showImage;

        public ERenderDTO(Object name, Icon showImage) {
            this.name = name;
            this.showImage = showImage;
        }

        public Object getName() {
            return this.name;
        }

        public void setName(Object name) {
            this.name = name;
        }

        public Icon getShowImage() {
            return this.showImage;
        }

        public void setShowImage(Icon showImage) {
            this.showImage = showImage;
        }

        public String toString() {
            return (String)this.name;
        }
    }
}

