/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class EQueryScope
extends JPanel {
    private JTextComponent txtStart = null;
    private JTextComponent txtEnd = null;
    private JLabel endTip = null;
    private JComboBox operations = new JComboBox<String>(new String[]{"\u2265", "\uff1d", "\u2264"});
    public static final String START_TXT_OPR_GE = "\u2265";
    public static final String START_TXT_OPR_E = "\uff1d";
    public static final String START_TXT_OPR_LE = "\u2264";

    public EQueryScope(JTextField txtStart, JTextField txtEnd) {
        this.txtStart = txtStart;
        this.txtEnd = txtEnd;
        this.initGUI();
        this.operations.addItemListener(new ItemListenerImpl());
    }

    protected void initGUI() {
        super.setLayout(new GridBagLayout());
        this.add(this.operations, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0), 0);
        this.add(this.txtStart, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 1, 0), 1);
        this.endTip = new JLabel("\u4e14\u2264");
        this.add(this.endTip, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0), 2);
        this.add(this.txtEnd, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 1, 0), 3);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String toSQL() {
        String start = this.txtStart.getText().trim();
        String end = this.txtEnd.getText().trim();
        int startTxtOperation = this.operations.getSelectedIndex();
        if (startTxtOperation > 0) {
            if (start.length() == 0) {
                return "isnull";
            }
            if (startTxtOperation == 1) {
                return "='" + start + '\'';
            }
            return "<='" + start + '\'';
        }
        if (start.length() == 0) {
            if (end.length() == 0) {
                return "is null";
            }
            return "<='" + end + '\'';
        }
        if (end.length() == 0) {
            return ">='" + start + '\'';
        }
        return "BETWEEN '" + start + '\'' + " AND '" + end + '\'';
    }

    public void setDefaultOperation(String operation) {
        this.operations.setSelectedItem(operation);
    }

    public String getDefaultOperation() {
        return (String)this.operations.getSelectedItem();
    }

    public String getPrintString() {
        String strStart = this.txtStart.getText();
        String strEnd = this.txtEnd.getText();
        String operand = this.getDefaultOperation();
        if (operand.equals(START_TXT_OPR_E)) {
            return strStart;
        }
        if (operand.equals(START_TXT_OPR_LE)) {
            return String.valueOf(operand) + " " + strEnd;
        }
        if (operand.equals(START_TXT_OPR_GE)) {
            if (strEnd != null && strEnd.length() > 0) {
                return this.txtStart + "\uff5e" + strEnd;
            }
            return String.valueOf(operand) + " " + this.txtStart;
        }
        return "";
    }

    public JTextComponent getTxtStart() {
        return this.txtStart;
    }

    public void setTxtStart(JTextComponent txtStart) {
        this.txtStart = txtStart;
    }

    public JTextComponent getTxtEnd() {
        return this.txtEnd;
    }

    public void setTxtEnd(JTextComponent txtEnd) {
        this.txtEnd = txtEnd;
    }

    public JLabel getEndTip() {
        return this.endTip;
    }

    public void setEndTip(JLabel endTip) {
        this.endTip = endTip;
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                EQueryScope.this.txtEnd.setEnabled(EQueryScope.this.operations.getSelectedIndex() == 0);
                EQueryScope.this.endTip.setEnabled(EQueryScope.this.operations.getSelectedIndex() == 0);
                if (EQueryScope.this.operations.getSelectedIndex() != 0) {
                    EQueryScope.this.txtEnd.setText(null);
                }
            }
        }
    }
}

