/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.painter;

import com.eva.epc.swingx.painter.Painter;
import com.eva.epc.widget.util.GraphicHandler;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Color;
import java.awt.Graphics2D;

public class StringIconBgPainter
implements Painter {
    private FillType selectedFillType = FillType.Crystal;
    private int x;
    private int y;
    private int arc;
    private Color bgColor;
    private boolean needFill = true;

    public void paint(Graphics2D g, Object object, int width, int height) {
        this.doPaint(g, object, width, height);
    }

    protected void doPaint(Graphics2D g, Object bpi, int width, int height) {
        if (this.needFill) {
            if (this.selectedFillType == FillType.Crystal) {
                GraphicHandler.fillCrystalRoundRec(g, this.bgColor, this.x, this.y, width, height, this.arc);
            } else if (this.selectedFillType == FillType.Texture) {
                GraphicHandler.fillTextureRoundRec(g, this.bgColor, this.x, this.y, width, height, this.arc);
            }
        }
        SwingUtils.setAntiAliasing(g, true);
        g.setColor(GraphicHandler.getColor(this.bgColor, -10, -10, -10));
        g.drawRoundRect(this.x, this.y, width, height, this.arc, this.arc);
        if (this.needFill) {
            g.setColor(GraphicHandler.getColor(this.bgColor, 20, 20, 20));
            g.drawRoundRect(this.x + 1, this.y + 1, width - 2, height - 2, this.arc, this.arc);
        }
        SwingUtils.setAntiAliasing(g, false);
    }

    public FillType getSelectedFillType() {
        return this.selectedFillType;
    }

    public StringIconBgPainter setSelectedFillType(FillType selectedFillType) {
        this.selectedFillType = selectedFillType;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public StringIconBgPainter setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public StringIconBgPainter setY(int y) {
        this.y = y;
        return this;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public StringIconBgPainter setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getArc() {
        return this.arc;
    }

    public StringIconBgPainter setArc(int arc) {
        this.arc = arc;
        return this;
    }

    public boolean isNeedFill() {
        return this.needFill;
    }

    public StringIconBgPainter setNeedFill(boolean needFill) {
        this.needFill = needFill;
        return this;
    }

    public static enum FillType {
        Crystal,
        Texture;

    }
}

