/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.icon;

import com.eva.epc.swingx.painter.Painter;
import com.eva.epc.swingx.painter.StringIconBgPainter;
import com.eva.epc.widget.util.SwingUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class StringIcon
implements Icon {
    public static final Color DEFAULT_BG_COLOR = new Color(231, 106, 30);
    public static final Color DEFAULT_FG_COLOR = Color.white;
    private int width = 16;
    private int height = 16;
    private String drawingStr = "";
    protected RenderingHints hints = null;
    protected boolean scaleIfStringFlow = true;
    protected Color bgColor = DEFAULT_BG_COLOR;
    protected Color fColor = DEFAULT_FG_COLOR;
    protected int arc = 4;
    private boolean needFill = true;
    protected boolean aa = false;
    protected StringIconBgPainter bgPainter = new StringIconBgPainter();
    protected Font fFont = new Font("\u5b8b\u4f53", 0, 12);

    public StringIcon(String drawingStr) {
        this(true, drawingStr, null, null);
    }

    public StringIcon(boolean scaleIfStringFlow, String drawingStr, Color bgColog, Color fColor) {
        this.scaleIfStringFlow = scaleIfStringFlow;
        this.drawingStr = drawingStr;
        if (bgColog != null) {
            this.bgColor = bgColog;
        }
        if (fColor != null) {
            this.fColor = fColor;
        }
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected int getStrPixWidth() {
        return SwingUtils.getStrPixWidth(this.fFont, String.valueOf(this.drawingStr));
    }

    protected int getStrPixHeight() {
        return SwingUtils.getStrPixHeight(this.fFont);
    }

    @Override
    public int getIconWidth() {
        int sw = this.getStrPixWidth();
        if (this.scaleIfStringFlow && this.width <= sw + 2) {
            this.width = sw + 2;
        }
        return this.width;
    }

    @Override
    public int getIconHeight() {
        int sh = this.getStrPixHeight();
        if (this.scaleIfStringFlow && this.height < sh) {
            this.height = sh;
        }
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Font oldFont = g2.getFont();
        g2.setFont(this.fFont);
        RenderingHints oldHint = g2.getRenderingHints();
        g2.setRenderingHints(this.hints);
        this.bgPainter.setX(x).setY(y).setArc(this.arc).setBgColor(this.bgColor).setNeedFill(this.needFill);
        this.bgPainter.paint(g2, (Object)null, this.getIconWidth(), this.getIconHeight());
        g2.setColor(this.fColor);
        if (!this.aa) {
            g2.setRenderingHints(oldHint);
        }
        g2.drawString(String.valueOf(this.drawingStr), x + (this.getIconWidth() - this.getStrPixWidth()) / 2, y + g2.getFontMetrics().getAscent());
        g2.setRenderingHints(oldHint);
        g2.setFont(oldFont);
    }

    public int getWidth() {
        return this.getIconWidth();
    }

    public StringIcon setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.getIconHeight();
    }

    public StringIcon setHeight(int height) {
        this.height = height;
        return this;
    }

    public String getDrawingStr() {
        return this.drawingStr;
    }

    public StringIcon setDrawingStr(String drawingStr) {
        this.drawingStr = drawingStr;
        return this;
    }

    public boolean isScaleIfStringFlow() {
        return this.scaleIfStringFlow;
    }

    public StringIcon setScaleIfStringFlow(boolean scaleIfStringFlow) {
        this.scaleIfStringFlow = scaleIfStringFlow;
        return this;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public StringIcon setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public Painter getBgPainter() {
        return this.bgPainter;
    }

    public StringIcon setBgPainter(StringIconBgPainter bgPainter) {
        this.bgPainter = bgPainter;
        return this;
    }

    public Color getFColor() {
        return this.fColor;
    }

    public StringIcon setFColor(Color color) {
        this.fColor = color;
        return this;
    }

    public int getArc() {
        return this.arc;
    }

    public StringIcon setArc(int arc) {
        this.arc = arc;
        return this;
    }

    public boolean isAa() {
        return this.aa;
    }

    public StringIcon setAa(boolean aa) {
        this.aa = aa;
        return this;
    }

    public Font getFFont() {
        return this.fFont;
    }

    public StringIcon setFFont(Font font) {
        this.fFont = font;
        return this;
    }

    public boolean isNeedFill() {
        return this.needFill;
    }

    public StringIcon setNeedFill(boolean needFill) {
        this.needFill = needFill;
        return this;
    }

    public String toString() {
        return this.drawingStr;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JLabel label = new JLabel("\u6211\u662f\u4e2d\u56fd\u4eba\u4f60\u5988\u5988\u5988", new StringIcon(" \u9500\u552e\u7c7b ").setArc(10).setAa(false).setNeedFill(false).setFColor(DEFAULT_BG_COLOR), 2);
        frame.getContentPane().add("Center", label);
        frame.pack();
        frame.setVisible(true);
    }
}

