/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx;

import com.eva.epc.swingx.action.AbstractActionExt;
import com.eva.epc.swingx.action.ActionContainerFactory;
import com.eva.epc.swingx.action.BoundAction;
import com.eva.epc.swingx.search.PatternModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractPatternPanel
extends JPanel {
    public static final String SEARCH_FIELD_LABEL = "\u67e5\u627e\u5185\u5bb9";
    public static final String SEARCH_FIELD_MNEMONIC = "\u67e5\u627e\u5185\u5bb9.mnemonic";
    public static final String SEARCH_TITLE = "\u67e5\u627e";
    public static final String MATCH_ACTION_COMMAND = "\u67e5\u627e\u4e0b\u4e00\u5904";
    protected JLabel searchLabel;
    protected JTextField searchField;
    protected JCheckBox matchCheck;
    protected PatternModel patternModel;
    private ActionContainerFactory actionFactory;

    public abstract void match();

    protected AbstractActionExt getAction(String key) {
        return (AbstractActionExt)this.getActionMap().get(key);
    }

    protected void initActions() {
        this.initPatternActions();
        this.initExecutables();
    }

    protected void initExecutables() {
        AbstractActionExt execute = this.createBoundAction(MATCH_ACTION_COMMAND, "match");
        this.getActionMap().put("execute", execute);
        this.getActionMap().put(MATCH_ACTION_COMMAND, execute);
        this.refreshEmptyFromModel();
    }

    protected void initPatternActions() {
        ActionMap map = this.getActionMap();
        map.put("\u533a\u5206\u5927\u5c0f\u5199", this.createModelStateAction("\u533a\u5206\u5927\u5c0f\u5199", "setCaseSensitive", this.getPatternModel().isCaseSensitive()));
        map.put("\u5faa\u73af\u67e5\u627e", this.createModelStateAction("\u5faa\u73af\u67e5\u627e", "setWrapping", this.getPatternModel().isWrapping()));
        map.put("\u7cbe\u786e\u5230\u5217", this.createModelStateAction("\u7cbe\u786e\u5230\u5217", "setBackwards", this.getPatternModel().isBackwards()));
        map.put("matchIncremental", this.createModelStateAction("matchIncremental", "setIncremental", this.getPatternModel().isIncremental()));
    }

    protected String getUIString(String key) {
        return this.getUIString(key, this.getLocale());
    }

    protected String getUIString(String key, Locale locale) {
        return key;
    }

    protected AbstractActionExt createModelStateAction(String command, String methodName, boolean initial) {
        String actionName = this.getUIString(command);
        BoundAction action = new BoundAction(actionName, command);
        action.setStateAction();
        action.registerCallback(this.getPatternModel(), methodName);
        action.setSelected(initial);
        return action;
    }

    protected AbstractActionExt createBoundAction(String actionCommand, String methodName) {
        String actionName = this.getUIString(actionCommand);
        BoundAction action = new BoundAction(actionName, actionCommand);
        action.registerCallback(this, methodName);
        return action;
    }

    @Override
    public void setLocale(Locale l) {
        this.updateLocaleState(l);
        super.setLocale(l);
    }

    protected void updateLocaleState(Locale locale) {
        Object[] objectArray = this.getActionMap().allKeys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyString;
            Object key = objectArray[n2];
            if (key instanceof String && !key.equals(keyString = this.getUIString((String)key, locale))) {
                this.getActionMap().get(key).putValue("Name", keyString);
            }
            ++n2;
        }
        this.bindSearchLabel(locale);
    }

    protected void refreshPatternFromModel() {
        if (this.getPatternModel().isIncremental()) {
            this.match();
        }
    }

    public PatternModel getPatternModel() {
        if (this.patternModel == null) {
            this.patternModel = this.createPatternModel();
            this.patternModel.addPropertyChangeListener(this.getPatternModelListener());
        }
        return this.patternModel;
    }

    protected PatternModel createPatternModel() {
        return new PatternModel();
    }

    protected PropertyChangeListener getPatternModelListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("pattern".equals(property)) {
                    AbstractPatternPanel.this.refreshPatternFromModel();
                } else if ("rawText".equals(property)) {
                    AbstractPatternPanel.this.refreshDocumentFromModel();
                } else if ("caseSensitive".equals(property)) {
                    AbstractPatternPanel.this.getAction("\u533a\u5206\u5927\u5c0f\u5199").setSelected((Boolean)evt.getNewValue());
                } else if ("wrapping".equals(property)) {
                    AbstractPatternPanel.this.getAction("\u5faa\u73af\u67e5\u627e").setSelected((Boolean)evt.getNewValue());
                } else if ("backwards".equals(property)) {
                    AbstractPatternPanel.this.getAction("\u7cbe\u786e\u5230\u5217").setSelected((Boolean)evt.getNewValue());
                } else if ("incremental".equals(property)) {
                    AbstractPatternPanel.this.getAction("matchIncremental").setSelected((Boolean)evt.getNewValue());
                } else if ("empty".equals(property)) {
                    AbstractPatternPanel.this.refreshEmptyFromModel();
                }
            }
        };
    }

    protected void refreshEmptyFromModel() {
        boolean enabled = !this.getPatternModel().isEmpty();
        this.getAction(MATCH_ACTION_COMMAND).setEnabled(enabled);
    }

    protected void refreshModelFromDocument() {
        this.getPatternModel().setRawText(this.searchField.getText());
    }

    protected void refreshDocumentFromModel() {
        if (this.searchField.getText().equals(this.getPatternModel().getRawText())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPatternPanel.this.searchField.setText(AbstractPatternPanel.this.getPatternModel().getRawText());
            }
        });
    }

    protected DocumentListener getSearchFieldListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }
        };
    }

    protected void bind() {
        this.bindSearchLabel(this.getLocale());
        this.searchField.getDocument().addDocumentListener(this.getSearchFieldListener());
        this.getActionContainerFactory().configureButton(this.matchCheck, (AbstractActionExt)this.getActionMap().get("\u533a\u5206\u5927\u5c0f\u5199"), null);
    }

    protected void bindSearchLabel(Locale locale) {
        this.searchLabel.setText(this.getUIString(SEARCH_FIELD_LABEL, locale));
        String mnemonic = this.getUIString(SEARCH_FIELD_MNEMONIC, locale);
        if (mnemonic != SEARCH_FIELD_MNEMONIC) {
            this.searchLabel.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        this.searchLabel.setLabelFor(this.searchField);
    }

    protected ActionContainerFactory getActionContainerFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = new ActionContainerFactory(null);
        }
        return this.actionFactory;
    }

    protected void initComponents() {
        this.searchLabel = new JLabel();
        this.searchField = new JTextField(this.getSearchFieldWidth()){

            @Override
            public Dimension getMaximumSize() {
                Dimension superMax = super.getMaximumSize();
                superMax.height = this.getPreferredSize().height;
                return superMax;
            }
        };
        this.matchCheck = new JCheckBox();
    }

    protected int getSearchFieldWidth() {
        return 30;
    }
}

