/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLLookAndFeel;
import com.eva.epc.lnf.winlike.WLMetalBorders;
import com.eva.epc.lnf.winlike.WLTitlePane;
import com.eva.epc.lnf.winlike.WLUtils;
import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class WLInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;
    private boolean helpButtonVisible = false;

    public WLInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateOptionPaneState();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.wasClosable = this.frame.isClosable();
        this.selectedBackgroundKey = null;
        this.selectedForegroundKey = null;
        this.setOpaque(true);
        this.helpButtonVisible = UIManager.getBoolean("InternalFrame.helpButtonVisible");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.wasClosable != this.frame.isClosable()) {
            this.frame.setClosable(this.wasClosable);
        }
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        Boolean paintActive = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", paintActive);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton.putClientProperty("paintActive", paintActive);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("paintActive", paintActive);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
    }

    @Override
    protected void createActions() {
        super.createActions();
        if (this.helpButtonVisible) {
            this.iconifyAction = new AbstractAction(ICONIFY_CMD){

                @Override
                public void actionPerformed(ActionEvent e) {
                    e.setSource(WLInternalFrameTitlePane.this.frame);
                    ((ActionListener)UIManager.get("InternalFrame.helpButtonAction")).actionPerformed(e);
                }
            };
        }
    }

    @Override
    protected void assembleSystemMenu() {
    }

    @Override
    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new XZCMetalTitlePaneLayout();
    }

    public void paintPalette(Graphics g) {
        boolean leftToRight = WLLookAndFeel.isLeftToRight(this.frame);
        int width = this.getWidth();
        int height = this.getHeight();
        ColorUIResource background = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
        WLTitlePane.paintTitlePane(g, 0, 0, width, height, false, background, darkShadow);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean leftToRight = WLLookAndFeel.isLeftToRight(this.frame);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = null;
        Color foreground = null;
        Color shadow = null;
        if (isSelected) {
            if (this.selectedBackgroundKey != null) {
                background = UIManager.getColor(this.selectedBackgroundKey);
            }
            if (background == null) {
                background = UIManager.getColor("activeCaption");
            }
            if (this.selectedForegroundKey != null) {
                foreground = UIManager.getColor(this.selectedForegroundKey);
            }
            if (this.selectedShadowKey != null) {
                shadow = UIManager.getColor(this.selectedShadowKey);
            }
            if (shadow == null) {
                shadow = UIManager.getColor("activeCaptionBorder");
            }
            if (foreground == null) {
                foreground = UIManager.getColor("activeCaptionText");
            }
        } else {
            background = UIManager.getColor("inactiveCaption");
            foreground = UIManager.getColor("inactiveCaptionText");
            shadow = UIManager.getColor("inactiveCaptionBorder");
        }
        Color topDarkShadow2 = GraphicHandler.getColor(background, -40, -40, -40);
        Color topHightLight2 = GraphicHandler.getColor(background, 60, 60, 60);
        Color topDarkHightLight2 = GraphicHandler.getColor(background, 20, 20, 20);
        Border b = this.frame.getBorder();
        Insets is = b.getBorderInsets(this.frame);
        Rectangle bounds = this.getBounds();
        int paintTitlePaneX = bounds.x;
        int paintTitlePaneY = bounds.y;
        boolean isBUG = false;
        isBUG = is.left != bounds.x;
        if (isBUG) {
            paintTitlePaneX = is.left;
        }
        if (isBUG = is.top != bounds.y) {
            paintTitlePaneY = is.top;
        }
        if (isBUG) {
            g.setColor(topDarkShadow2);
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, 1, 0, height);
            g.drawLine(width, 1, width, height);
            g.setColor(topHightLight2);
            g.drawLine(1, 1, width - WLMetalBorders.InternalFrameDialogBorder.insets.left, 1);
            g.setColor(topDarkHightLight2);
            g.drawLine(2, 2, width - WLMetalBorders.InternalFrameDialogBorder.insets.left, 2);
            WLTitlePane.paintTitlePane(g, paintTitlePaneX, paintTitlePaneY, width - is.left * 2, height, isSelected, background, shadow);
        } else {
            WLTitlePane.paintTitlePane(g, 0, 0, width, height, isSelected, background, shadow);
        }
        int titleLength = 0;
        int xOffset = leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = WLUtils.getFontMetrics(this.frame, g, f);
            int fHeight = fm.getHeight();
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= WLUtils.stringWidth(this.frame, fm, frameTitle);
            }
            titleLength = WLUtils.stringWidth(this.frame, fm, frameTitle);
            g.setColor(Color.DARK_GRAY);
            WLUtils.drawString(this.frame, g, frameTitle, xOffset + 1, yOffset + 1);
            g.setColor(foreground);
            if (WLLookAndFeel.windowTitleAntialising) {
                WLLookAndFeel.setAntiAliasing((Graphics2D)g, true);
            }
            WLUtils.drawString(this.frame, g, frameTitle, xOffset, yOffset);
            if (WLLookAndFeel.windowTitleAntialising) {
                WLLookAndFeel.setAntiAliasing((Graphics2D)g, false);
            }
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void updateOptionPaneState() {
        int type = -2;
        boolean closable = this.wasClosable;
        Object obj = this.frame.getClientProperty("JInternalFrame.messageType");
        if (obj == null) {
            return;
        }
        if (obj instanceof Integer) {
            type = (Integer)obj;
        }
        switch (type) {
            case 0: {
                this.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 3: {
                this.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 2: {
                this.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case -1: 
            case 1: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
                closable = false;
                break;
            }
            default: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
            }
        }
        if (closable != this.frame.isClosable()) {
            this.frame.setClosable(closable);
        }
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
            super(WLInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                WLInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                WLInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                WLInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            } else if ("JInternalFrame.messageType".equals(prop)) {
                WLInternalFrameTitlePane.this.updateOptionPaneState();
                WLInternalFrameTitlePane.this.frame.repaint();
            }
            super.propertyChange(evt);
        }
    }

    class XZCMetalTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        XZCMetalTitlePaneLayout() {
            super(WLInternalFrameTitlePane.this);
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (WLInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (WLInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (WLInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (WLInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (WLInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (WLInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = WLInternalFrameTitlePane.this.frame.getFontMetrics(WLInternalFrameTitlePane.this.getFont());
            String frameTitle = WLInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? WLUtils.stringWidth(WLInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = WLUtils.stringWidth(WLInternalFrameTitlePane.this.frame, fm, String.valueOf(WLInternalFrameTitlePane.this.frame.getTitle().substring(0, 2)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            if (WLInternalFrameTitlePane.this.isPalette) {
                height = WLInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int fontHeight = fm.getHeight();
                fontHeight += 4;
                Icon icon = WLInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 16);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = WLLookAndFeel.isLeftToRight(WLInternalFrameTitlePane.this.frame);
            int w = WLInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 2;
            int buttonHeight = WLInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = WLInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (WLInternalFrameTitlePane.this.frame.isClosable()) {
                if (WLInternalFrameTitlePane.this.isPalette) {
                    spacing = 3;
                    WLInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - (buttonWidth + 2) : spacing, y, buttonWidth + 2, WLInternalFrameTitlePane.this.getHeight() - 4);
                    if (!leftToRight) {
                        x += buttonWidth + 2;
                    }
                } else {
                    spacing = 4;
                    WLInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            if (WLInternalFrameTitlePane.this.frame.isMaximizable() && !WLInternalFrameTitlePane.this.isPalette) {
                spacing = WLInternalFrameTitlePane.this.frame.isClosable() ? 2 : 4;
                WLInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (WLInternalFrameTitlePane.this.frame.isIconifiable() && !WLInternalFrameTitlePane.this.isPalette) {
                spacing = WLInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (WLInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                WLInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            WLInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }
}

