/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLLookAndFeel;
import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;

public class WLCheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI {
    private static boolean enforceTransparent = true;

    public static ComponentUI createUI(JComponent b) {
        return new WLCheckBoxMenuItemUI();
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            WLLookAndFeel.setAntiAliasing(g2, true);
            Paint oldpaint = g2.getPaint();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, GraphicHandler.getColor(bgColor, 35, 35, 35), 0.0f, menuHeight, bgColor);
            g2.setPaint(gp);
            g.fillRoundRect(0, 0, menuWidth, menuHeight, 5, 5);
            g2.setPaint(oldpaint);
            WLLookAndFeel.setAntiAliasing(g2, false);
        } else if (!enforceTransparent) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }
}

