/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SplitPaneDividerBorder
implements Border,
UIResource {
    Color highlight;
    Color shadow;

    public SplitPaneDividerBorder(Color highlight, Color shadow) {
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        JSplitPane splitPane = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI().getSplitPane();
        Dimension size = c.getSize();
        Component child = splitPane.getLeftComponent();
        g.setColor(c.getBackground());
        g.drawRect(x, y, width - 1, height - 1);
        BasicStroke sroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
        if (splitPane.getOrientation() == 1) {
            if (child != null) {
                g.setColor(this.highlight);
                g.drawLine(0, 0, 0, size.height);
            }
            if ((child = splitPane.getRightComponent()) != null) {
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(sroke);
                g2d.setColor(this.shadow);
                g2d.drawLine(size.width - 1, 0, size.width - 1, size.height);
                g2d.setStroke(oldStroke);
            }
        } else {
            if (child != null) {
                g.setColor(this.highlight);
                g.drawLine(0, 0, size.width, 0);
            }
            if ((child = splitPane.getRightComponent()) != null) {
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(sroke);
                g.setColor(this.shadow);
                g.drawLine(0, size.height - 1, size.width, size.height - 1);
                g2d.setStroke(oldStroke);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        JSplitPane splitPane;
        BasicSplitPaneUI bspui;
        Insets insets = new Insets(0, 0, 0, 0);
        if (c instanceof BasicSplitPaneDivider && (bspui = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI()) != null && (splitPane = bspui.getSplitPane()) != null) {
            if (splitPane.getOrientation() == 1) {
                insets.bottom = 0;
                insets.top = 0;
                insets.right = 1;
                insets.left = 1;
                return insets;
            }
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 0;
            insets.left = 0;
            return insets;
        }
        insets.right = 1;
        insets.left = 1;
        insets.bottom = 1;
        insets.top = 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

