/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.qos;

import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.x52im.mobileimsdk.server.ServerLauncher;
import net.x52im.mobileimsdk.server.network.MBObserver;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.utils.LocalSendHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QoS4SendDaemonRoot {
    private static Logger logger = LoggerFactory.getLogger(QoS4SendDaemonRoot.class);
    private boolean DEBUG = false;
    private ServerLauncher serverLauncher = null;
    private ConcurrentSkipListMap<String, Protocal> sentMessages = new ConcurrentSkipListMap();
    private ConcurrentMap<String, Long> sendMessagesTimestamp = new ConcurrentHashMap<String, Long>();
    private int CHECH_INTERVAL = 5000;
    private int MESSAGES_JUST$NOW_TIME = 2000;
    private int QOS_TRY_COUNT = 1;
    private boolean _excuting = false;
    private Timer timer = null;
    private String debugTag = "";

    public QoS4SendDaemonRoot(int CHECH_INTERVAL, int MESSAGES_JUST$NOW_TIME, int QOS_TRY_COUNT, boolean DEBUG, String debugTag) {
        if (CHECH_INTERVAL > 0) {
            this.CHECH_INTERVAL = CHECH_INTERVAL;
        }
        if (MESSAGES_JUST$NOW_TIME > 0) {
            this.MESSAGES_JUST$NOW_TIME = MESSAGES_JUST$NOW_TIME;
        }
        if (QOS_TRY_COUNT >= 0) {
            this.QOS_TRY_COUNT = QOS_TRY_COUNT;
        }
        this.DEBUG = DEBUG;
        this.debugTag = debugTag;
    }

    private void doTaskOnece() {
        if (!this._excuting) {
            ArrayList<Protocal> lostMessages;
            block10: {
                lostMessages = new ArrayList<Protocal>();
                this._excuting = true;
                try {
                    if (this.DEBUG && this.sentMessages.size() > 0) {
                        logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011====== \u6d88\u606f\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u7ebf\u7a0b\u8fd0\u884c\u4e2d, \u5f53\u524d\u9700\u8981\u5904\u7406\u7684\u5217\u8868\u957f\u5ea6\u4e3a" + this.sentMessages.size() + "...");
                    }
                    for (Map.Entry<String, Protocal> entry : this.sentMessages.entrySet()) {
                        String key = entry.getKey();
                        final Protocal p = entry.getValue();
                        if (p != null && p.isQoS()) {
                            if (p.getRetryCount() >= this.QOS_TRY_COUNT) {
                                if (this.DEBUG) {
                                    logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5305\u91cd\u4f20\u6b21\u6570\u5df2\u8fbe" + p.getRetryCount() + "(\u6700\u591a" + this.QOS_TRY_COUNT + "\u6b21)\u4e0a\u9650\uff0c\u5c06\u5224\u5b9a\u4e3a\u4e22\u5305\uff01");
                                }
                                lostMessages.add((Protocal)p.clone());
                                this.remove(p.getFp());
                                continue;
                            }
                            Long sendMessageTimestamp = (Long)this.sendMessagesTimestamp.get(key);
                            long delta = System.currentTimeMillis() - (sendMessageTimestamp == null ? 0L : sendMessageTimestamp);
                            if (delta <= (long)this.MESSAGES_JUST$NOW_TIME) {
                                if (!this.DEBUG) continue;
                                logger.warn("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + key + "\u7684\u5305\u8ddd\"\u521a\u521a\"\u53d1\u51fa\u624d" + delta + "ms(<=" + this.MESSAGES_JUST$NOW_TIME + "ms\u5c06\u88ab\u8ba4\u5b9a\u662f\"\u521a\u521a\"), \u672c\u6b21\u4e0d\u9700\u8981\u91cd\u4f20\u54e6.");
                                continue;
                            }
                            MBObserver sendResultObserver = new MBObserver(){

                                @Override
                                public void update(boolean sendOK, Object extraObj) {
                                    if (sendOK) {
                                        if (QoS4SendDaemonRoot.this.DEBUG) {
                                            logger.debug("\u3010IMCORE" + QoS4SendDaemonRoot.this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5305\u5df2\u6210\u529f\u8fdb\u884c\u91cd\u4f20\uff0c\u6b64\u6b21\u4e4b\u540e\u91cd\u4f20\u6b21\u6570\u5df2\u8fbe" + p.getRetryCount() + "(\u6700\u591a" + QoS4SendDaemonRoot.this.QOS_TRY_COUNT + "\u6b21).");
                                        }
                                    } else if (QoS4SendDaemonRoot.this.DEBUG) {
                                        logger.warn("\u3010IMCORE" + QoS4SendDaemonRoot.this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5305\u91cd\u4f20\u5931\u8d25\uff0c\u5b83\u7684\u91cd\u4f20\u6b21\u6570\u4e4b\u524d\u5df2\u7d2f\u8ba1\u4e3a" + p.getRetryCount() + "(\u6700\u591a" + QoS4SendDaemonRoot.this.QOS_TRY_COUNT + "\u6b21).");
                                    }
                                }
                            };
                            LocalSendHelper.sendData(p, sendResultObserver);
                            p.increaseRetryCount();
                            continue;
                        }
                        this.remove(key);
                    }
                }
                catch (Exception eee) {
                    if (!this.DEBUG) break block10;
                    logger.warn("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6d88\u606f\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u7ebf\u7a0b\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38," + eee.getMessage(), (Throwable)eee);
                }
            }
            if (lostMessages != null && lostMessages.size() > 0) {
                this.notifyMessageLost(lostMessages);
            }
            this._excuting = false;
        }
    }

    protected void notifyMessageLost(ArrayList<Protocal> lostMessages) {
        if (this.serverLauncher != null && this.serverLauncher.getServerMessageQoSEventListener() != null) {
            this.serverLauncher.getServerMessageQoSEventListener().messagesLost(lostMessages);
        }
    }

    public QoS4SendDaemonRoot startup(boolean immediately) {
        this.stop();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                QoS4SendDaemonRoot.this.doTaskOnece();
            }
        }, immediately ? 0L : (long)this.CHECH_INTERVAL, (long)this.CHECH_INTERVAL);
        logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011====== \u6d88\u606f\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u7ebf\u7a0b\u5df2\u6210\u529f\u542f\u52a8");
        return this;
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            finally {
                this.timer = null;
            }
        }
    }

    public boolean isRunning() {
        return this.timer != null;
    }

    public boolean exist(String fingerPrint) {
        return this.sentMessages.get(fingerPrint) != null;
    }

    public void put(Protocal p) {
        if (p == null) {
            if (this.DEBUG) {
                logger.warn(this.debugTag + "Invalid arg p==null.");
            }
            return;
        }
        if (p.getFp() == null) {
            if (this.DEBUG) {
                logger.warn(this.debugTag + "Invalid arg p.getFp() == null.");
            }
            return;
        }
        if (!p.isQoS()) {
            if (this.DEBUG) {
                logger.warn(this.debugTag + "This protocal is not QoS pkg, ignore it!");
            }
            return;
        }
        if (this.sentMessages.get(p.getFp()) != null && this.DEBUG) {
            logger.warn("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5df2\u7ecf\u653e\u5165\u4e86\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u961f\u5217\uff0c\u8be5\u6d88\u606f\u4e3a\u4f55\u4f1a\u91cd\u590d\uff1f\uff08\u751f\u6210\u7684\u6307\u7eb9\u7801\u91cd\u590d\uff1f\u8fd8\u662f\u91cd\u590dput\uff1f\uff09");
        }
        this.sentMessages.put(p.getFp(), p);
        this.sendMessagesTimestamp.put(p.getFp(), System.currentTimeMillis());
    }

    public void remove(String fingerPrint) {
        block3: {
            try {
                this.sendMessagesTimestamp.remove(fingerPrint);
                Protocal result = this.sentMessages.remove(fingerPrint);
                if (this.DEBUG) {
                    logger.warn("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011\u6307\u7eb9\u4e3a" + fingerPrint + "\u7684\u6d88\u606f\u5df2\u6210\u529f\u4ece\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u961f\u5217\u4e2d\u79fb\u9664(\u53ef\u80fd\u662f\u6536\u5230\u63a5\u6536\u65b9\u7684\u5e94\u7b54\u4e5f\u53ef\u80fd\u662f\u8fbe\u5230\u4e86\u91cd\u4f20\u7684\u6b21\u6570\u4e0a\u9650)\uff0c\u91cd\u8bd5\u6b21\u6570=" + (result != null ? Integer.valueOf(result.getRetryCount()) : "none\u5475\u5475."));
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block3;
                logger.warn("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u53d1\u9001\u65b9\u3011remove(fingerPrint)\u65f6\u51fa\u9519\u4e86\uff1a", (Throwable)e);
            }
        }
    }

    public int size() {
        return this.sentMessages.size();
    }

    public void setServerLauncher(ServerLauncher serverLauncher) {
        this.serverLauncher = serverLauncher;
    }

    public QoS4SendDaemonRoot setDebugable(boolean debugable) {
        this.DEBUG = debugable;
        return this;
    }

    public boolean isDebugable() {
        return this.DEBUG;
    }
}

