/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.qos;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QoS4ReciveDaemonRoot {
    private static Logger logger = LoggerFactory.getLogger(QoS4ReciveDaemonRoot.class);
    private boolean DEBUG = false;
    private int CHECH_INTERVAL = 300000;
    private int MESSAGES_VALID_TIME = 600000;
    private ConcurrentMap<String, Long> recievedMessages = new ConcurrentHashMap<String, Long>();
    private Timer timer = null;
    private Runnable runnable = null;
    private boolean _excuting = false;
    private String debugTag = "";

    public QoS4ReciveDaemonRoot(int CHECH_INTERVAL, int MESSAGES_VALID_TIME, boolean DEBUG, String debugTag) {
        if (CHECH_INTERVAL > 0) {
            this.CHECH_INTERVAL = CHECH_INTERVAL;
        }
        if (MESSAGES_VALID_TIME > 0) {
            this.MESSAGES_VALID_TIME = MESSAGES_VALID_TIME;
        }
        this.DEBUG = DEBUG;
        this.debugTag = debugTag;
    }

    private void doTaskOnece() {
        if (!this._excuting) {
            this._excuting = true;
            if (this.DEBUG) {
                logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u63a5\u6536\u65b9\u3011+++++ START \u6682\u5b58\u5904\u7406\u7ebf\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u5f53\u524d\u957f\u5ea6" + this.recievedMessages.size() + ".");
            }
            for (Map.Entry entry : this.recievedMessages.entrySet()) {
                String key = (String)entry.getKey();
                long value = (Long)entry.getValue();
                long delta = System.currentTimeMillis() - value;
                if (delta < (long)this.MESSAGES_VALID_TIME) continue;
                if (this.DEBUG) {
                    logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u63a5\u6536\u65b9\u3011\u6307\u7eb9\u4e3a" + key + "\u7684\u5305\u5df2\u751f\u5b58" + delta + "ms(\u6700\u5927\u5141\u8bb8" + this.MESSAGES_VALID_TIME + "ms), \u9a6c\u4e0a\u5c06\u5220\u9664\u4e4b.");
                }
                this.recievedMessages.remove(key);
            }
        }
        if (this.DEBUG) {
            logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u63a5\u6536\u65b9\u3011+++++ END \u6682\u5b58\u5904\u7406\u7ebf\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u5f53\u524d\u957f\u5ea6" + this.recievedMessages.size() + ".");
        }
        this._excuting = false;
    }

    public void startup() {
        this.stop();
        if (this.recievedMessages != null && this.recievedMessages.size() > 0) {
            for (String key : this.recievedMessages.keySet()) {
                this.putImpl(key);
            }
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                QoS4ReciveDaemonRoot.this.doTaskOnece();
            }
        }, this.CHECH_INTERVAL, (long)this.CHECH_INTERVAL);
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            finally {
                this.timer = null;
            }
        }
    }

    public boolean isRunning() {
        return this.timer != null;
    }

    public void addRecieved(Protocal p) {
        if (p != null && p.isQoS()) {
            this.addRecieved(p.getFp());
        }
    }

    public void addRecieved(String fingerPrintOfProtocal) {
        if (fingerPrintOfProtocal == null) {
            logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u65e0\u6548\u7684 fingerPrintOfProtocal==null!");
            return;
        }
        if (this.recievedMessages.containsKey(fingerPrintOfProtocal)) {
            logger.debug("\u3010IMCORE" + this.debugTag + "\u3011\u3010QoS\u63a5\u6536\u65b9\u3011\u6307\u7eb9\u4e3a" + fingerPrintOfProtocal + "\u7684\u6d88\u606f\u5df2\u7ecf\u5b58\u5728\u4e8e\u63a5\u6536\u5217\u8868\u4e2d\uff0c\u8be5\u6d88\u606f\u91cd\u590d\u4e86\uff08\u539f\u7406\u53ef\u80fd\u662f\u5bf9\u65b9\u56e0\u672a\u6536\u5230\u5e94\u7b54\u5305\u800c\u9519\u8bef\u91cd\u4f20\u5bfc\u81f4\uff09\uff0c\u66f4\u65b0\u6536\u5230\u65f6\u95f4\u6233\u54e6.");
        }
        this.putImpl(fingerPrintOfProtocal);
    }

    private void putImpl(String fingerPrintOfProtocal) {
        if (fingerPrintOfProtocal != null) {
            this.recievedMessages.put(fingerPrintOfProtocal, System.currentTimeMillis());
        }
    }

    public boolean hasRecieved(String fingerPrintOfProtocal) {
        return this.recievedMessages.containsKey(fingerPrintOfProtocal);
    }

    public int size() {
        return this.recievedMessages.size();
    }

    public QoS4ReciveDaemonRoot setDebugable(boolean debugable) {
        this.DEBUG = debugable;
        return this;
    }

    public boolean isDebugable() {
        return this.DEBUG;
    }
}

