/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.processor;

import io.netty.channel.Channel;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.GatewayUDP;
import net.x52im.mobileimsdk.server.network.MBObserver;
import net.x52im.mobileimsdk.server.processor.BridgeProcessor;
import net.x52im.mobileimsdk.server.processor.OnlineProcessor;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;
import net.x52im.mobileimsdk.server.qos.QoS4ReciveDaemonC2S;
import net.x52im.mobileimsdk.server.qos.QoS4SendDaemonS2C;
import net.x52im.mobileimsdk.server.utils.GlobalSendHelper;
import net.x52im.mobileimsdk.server.utils.LocalSendHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicProcessor {
    private static Logger logger = LoggerFactory.getLogger(LogicProcessor.class);
    private ServerCoreHandler serverCoreHandler = null;

    public LogicProcessor(ServerCoreHandler serverCoreHandler) {
        this.serverCoreHandler = serverCoreHandler;
    }

    public void processC2CMessage(BridgeProcessor bridgeProcessor, Channel session, Protocal pFromClient, String remoteAddress) throws Exception {
        GlobalSendHelper.sendDataC2C(bridgeProcessor, session, pFromClient, remoteAddress, this.serverCoreHandler);
    }

    public void processC2SMessage(Channel session, final Protocal pFromClient, String remoteAddress) throws Exception {
        if (pFromClient.isQoS()) {
            boolean hasRecieved = QoS4ReciveDaemonC2S.getInstance().hasRecieved(pFromClient.getFp());
            QoS4ReciveDaemonC2S.getInstance().addRecieved(pFromClient);
            LocalSendHelper.replyRecievedBack(session, pFromClient, new MBObserver(){

                @Override
                public void update(boolean receivedBackSendSucess, Object extraObj) {
                    if (receivedBackSendSucess) {
                        logger.debug("[IMCORE-\u672c\u673aQoS\uff01]\u3010QoS_\u5e94\u7b54_C2S\u3011\u5411" + pFromClient.getFrom() + "\u53d1\u9001" + pFromClient.getFp() + "\u7684\u5e94\u7b54\u5305\u6210\u529f\u4e86,from=" + pFromClient.getTo() + ".");
                    }
                }
            });
            if (hasRecieved) {
                if (QoS4ReciveDaemonC2S.getInstance().isDebugable()) {
                    logger.debug("[IMCORE-\u672c\u673aQoS\uff01]\u3010QoS\u673a\u5236\u3011" + pFromClient.getFp() + "\u56e0\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d1\u9001\u5217\u8868\u4e2d\uff0c\u8fd9\u662f\u91cd\u590d\u5305\uff0c\u672c\u6b21\u5ffd\u7565\u901a\u77e5\u4e1a\u52a1\u5904\u7406\u5c42\uff08\u53ea\u9700\u8981\u56de\u590dACK\u5c31\u884c\u4e86\uff09\uff01");
                }
                return;
            }
        }
        boolean processedOK = this.serverCoreHandler.getServerEventListener().onTransferMessage4C2S(pFromClient, session);
    }

    public void processACK(Protocal pFromClient, String remoteAddress) throws Exception {
        String theFingerPrint = pFromClient.getDataContent();
        logger.debug("[IMCORE-\u672c\u673aQoS\uff01]\u3010QoS\u673a\u5236_S2C\u3011\u6536\u5230\u63a5\u6536\u8005" + pFromClient.getFrom() + "\u56de\u8fc7\u6765\u7684\u6307\u7eb9\u4e3a" + theFingerPrint + "\u7684\u5e94\u7b54\u5305.");
        if (this.serverCoreHandler.getServerMessageQoSEventListener() != null) {
            this.serverCoreHandler.getServerMessageQoSEventListener().messagesBeReceived(theFingerPrint);
        }
        QoS4SendDaemonS2C.getInstance().remove(theFingerPrint);
    }

    public void processLogin(final Channel session, Protocal pFromClient, final String remoteAddress) throws Exception {
        PLoginInfo loginInfo = ProtocalFactory.parsePLoginInfo(pFromClient.getDataContent());
        if (loginInfo == null || loginInfo.getLoginUserId() == null) {
            logger.warn("[IMCORE-{}]>> \u6536\u5230\u5ba2\u6237\u7aef{}\u767b\u9646\u4fe1\u606f\uff0c\u4f46loginInfo\u6216loginInfo.getLoginUserId()\u662fnull\uff0c\u767b\u9646\u65e0\u6cd5\u7ee7\u7eed[uid={}\u3001token={}\u3001firstLoginTime={}]\uff01", new Object[]{Gateway.$(session), remoteAddress, loginInfo, loginInfo != null ? loginInfo.getLoginUserId() : null, loginInfo != null ? Long.valueOf(loginInfo.getFirstLoginTime()) : null});
            if (!GatewayUDP.isUDPChannel(session)) {
                session.close();
            }
            return;
        }
        logger.info("[IMCORE-{}]>> \u5ba2\u6237\u7aef" + remoteAddress + "\u53d1\u8fc7\u6765\u7684\u767b\u9646\u4fe1\u606f\u5185\u5bb9\u662f\uff1auid={}\u3001token={}\u3001firstLoginTime={}", new Object[]{Gateway.$(session), loginInfo.getLoginUserId(), loginInfo.getLoginToken(), loginInfo.getFirstLoginTime()});
        if (this.serverCoreHandler.getServerEventListener() != null) {
            boolean alreadyLogined = OnlineProcessor.isLogined(session);
            if (alreadyLogined) {
                logger.debug("[IMCORE-{}]>> \u3010\u6ce8\u610f\u3011\u5ba2\u6237\u7aef{}\u7684\u4f1a\u8bdd\u6b63\u5e38\u4e14\u5df2\u7ecf\u767b\u9646\u8fc7\uff0c\u800c\u6b64\u65f6\u53c8\u91cd\u65b0\u767b\u9646\uff1auid={}\u3001token={}\u3001firstLoginTime={}", new Object[]{Gateway.$(session), remoteAddress, loginInfo.getLoginUserId(), loginInfo.getLoginToken(), loginInfo.getFirstLoginTime()});
                this.processLoginSucessSend(session, loginInfo, remoteAddress);
            } else {
                int code = this.serverCoreHandler.getServerEventListener().onUserLoginVerify(loginInfo.getLoginUserId(), loginInfo.getLoginToken(), loginInfo.getExtra(), session);
                if (code == 0) {
                    this.processLoginSucessSend(session, loginInfo, remoteAddress);
                } else {
                    logger.warn("[IMCORE-{}]>> \u5ba2\u6237\u7aef{}\u767b\u9646\u5931\u8d25\u3010no\u3011\uff0c\u9a6c\u4e0a\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff0c\u5e76\u5173\u95ed\u5176\u4f1a\u8bdd\u3002\u3002\u3002", (Object)Gateway.$(session), (Object)remoteAddress);
                    MBObserver sendResultObserver = new MBObserver(){

                        @Override
                        public void update(boolean sendOK, Object extraObj) {
                            logger.warn("[IMCORE-{}]>> \u5ba2\u6237\u7aef{}\u767b\u9646\u5931\u8d25\u4fe1\u606f\u8fd4\u56de\u6210\u529f\uff1f{}\uff08\u4f1a\u8bdd\u5373\u5c06\u5173\u95ed\uff09", new Object[]{Gateway.$(session), remoteAddress, sendOK});
                            session.close();
                        }
                    };
                    LocalSendHelper.sendData(session, ProtocalFactory.createPLoginInfoResponse(code, -1L, "-1"), GatewayUDP.isUDPChannel(session) ? null : sendResultObserver);
                }
            }
        } else {
            logger.warn("[IMCORE-{}]>> \u6536\u5230\u5ba2\u6237\u7aef{}\u767b\u9646\u4fe1\u606f\uff0c\u4f46\u56de\u8c03\u5bf9\u8c61\u662fnull\uff0c\u6ca1\u6709\u8fdb\u884c\u56de\u8c03.", (Object)Gateway.$(session), (Object)remoteAddress);
        }
    }

    private void processLoginSucessSend(final Channel session, final PLoginInfo loginInfo, final String remoteAddress) throws Exception {
        final long firstLoginTimeFromClient = loginInfo.getFirstLoginTime();
        boolean firstLogin = PLoginInfo.isFirstLogin(firstLoginTimeFromClient);
        final long firstLoginTimeToClient = firstLogin ? System.currentTimeMillis() : firstLoginTimeFromClient;
        MBObserver sendResultObserver = new MBObserver(){

            @Override
            public void update(boolean __sendOK, Object extraObj) {
                if (__sendOK) {
                    boolean putOK = OnlineProcessor.getInstance().putUser(loginInfo.getLoginUserId(), firstLoginTimeFromClient, session);
                    if (putOK) {
                        OnlineProcessor.setUserIdForChannel(session, loginInfo.getLoginUserId());
                        OnlineProcessor.setFirstLoginTimeForChannel(session, firstLoginTimeToClient);
                        LogicProcessor.this.serverCoreHandler.getServerEventListener().onUserLoginSucess(loginInfo.getLoginUserId(), loginInfo.getExtra(), session);
                    }
                } else {
                    logger.warn("[IMCORE-{}]>> \u53d1\u7ed9\u5ba2\u6237\u7aef{}\u7684\u767b\u9646\u6210\u529f\u4fe1\u606f\u53d1\u9001\u5931\u8d25\u4e86\u3010no\u3011\uff01", (Object)Gateway.$(session), (Object)remoteAddress);
                }
            }
        };
        LocalSendHelper.sendData(session, ProtocalFactory.createPLoginInfoResponse(0, firstLoginTimeToClient, loginInfo.getLoginUserId()), sendResultObserver);
    }

    public void processKeepAlive(Channel session, Protocal pFromClient, String remoteAddress) throws Exception {
        String userId = OnlineProcessor.getUserIdFromChannel(session);
        if (userId != null) {
            LocalSendHelper.sendData(ProtocalFactory.createPKeepAliveResponse(userId), null);
        } else {
            logger.warn("[IMCORE-{}]>> Server\u5728\u56de\u5ba2\u6237\u7aef{}\u7684\u54cd\u5e94\u5305\u65f6\uff0c\u8c03\u7528getUserIdFromSession\u8fd4\u56denull\uff0c\u7528\u6237\u5728\u8fd9\u4e00\u77ac\u95f4\u6389\u7ebf\u4e86\uff1f\uff01", (Object)Gateway.$(session), (Object)remoteAddress);
        }
    }
}

