/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.websocket.MBWebsocketClientInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayWebsocket
extends Gateway {
    private static Logger logger = LoggerFactory.getLogger(GatewayWebsocket.class);
    public static String WEBSOCKET_PATH = "/websocket";
    public static int PORT = 3000;
    public static int SESION_RECYCLER_EXPIRE = 20;
    public static SslContext sslContext = null;
    protected final EventLoopGroup __bossGroup4Netty = new NioEventLoopGroup(1);
    protected final EventLoopGroup __workerGroup4Netty = new NioEventLoopGroup();
    protected Channel __serverChannel4Netty = null;
    protected ServerBootstrap bootstrap = null;

    @Override
    public void init(ServerCoreHandler serverCoreHandler) {
        this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.__bossGroup4Netty, this.__workerGroup4Netty).channel(NioServerSocketChannel.class)).childHandler(this.initChildChannelHandler(serverCoreHandler));
    }

    @Override
    public void bind() throws Exception {
        ChannelFuture cf = this.bootstrap.bind(PORT).sync();
        if (cf.isSuccess()) {
            logger.info("[IMCORE-ws] \u57fa\u4e8eMobileIMSDK\u7684WebSocket\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u6210\u529f \u221a " + (GatewayWebsocket.isSsl() ? "(\u5df2\u5f00\u542fSSL/TLS\u52a0\u5bc6\u4f20\u8f93)" : ""));
        } else {
            logger.info("[IMCORE-ws] \u57fa\u4e8eMobileIMSDK\u7684WebSocket\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u5931\u8d25 \u00d7");
        }
        this.__serverChannel4Netty = cf.channel();
        this.__serverChannel4Netty.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                GatewayWebsocket.this.__bossGroup4Netty.shutdownGracefully();
                GatewayWebsocket.this.__workerGroup4Netty.shutdownGracefully();
            }
        });
        logger.info("[IMCORE-ws] .... continue ...");
        logger.info("[IMCORE-ws] \u57fa\u4e8eMobileIMSDK\u7684WebSocket\u670d\u52a1\u6b63\u5728\u7aef\u53e3" + PORT + "\u4e0a\u76d1\u542c\u4e2d...");
    }

    @Override
    public void shutdown() {
        if (this.__serverChannel4Netty != null) {
            this.__serverChannel4Netty.close();
        }
    }

    protected ChannelHandler initChildChannelHandler(final ServerCoreHandler serverCoreHandler) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (sslContext != null) {
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WEBSOCKET_PATH, null, true)});
                pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(SESION_RECYCLER_EXPIRE)});
                pipeline.addLast(new ChannelHandler[]{new MBWebsocketClientInboundHandler(serverCoreHandler)});
            }
        };
    }

    public static boolean isSsl() {
        return sslContext != null;
    }
}

