/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import net.x52im.mobileimsdk.server.ServerCoreHandler;

public abstract class Gateway {
    public static final String SOCKET_TYPE_IN_CHANNEL_ATTRIBUTE = "__socket_type__";
    public static final AttributeKey<Integer> SOCKET_TYPE_IN_CHANNEL_ATTRIBUTE_ATTR = AttributeKey.newInstance((String)"__socket_type__");
    public static final int SOCKET_TYPE_UDP = 1;
    public static final int SOCKET_TYPE_TCP = 2;
    public static final int SOCKET_TYPE_WEBSOCKET = 4;

    public abstract void init(ServerCoreHandler var1);

    public abstract void bind() throws Exception;

    public abstract void shutdown();

    public static void setSocketType(Channel c, int socketType) {
        c.attr(SOCKET_TYPE_IN_CHANNEL_ATTRIBUTE_ATTR).set((Object)socketType);
    }

    public static void removeSocketType(Channel c) {
        c.attr(SOCKET_TYPE_IN_CHANNEL_ATTRIBUTE_ATTR).set(null);
    }

    public static int getSocketType(Channel c) {
        Integer socketType = (Integer)c.attr(SOCKET_TYPE_IN_CHANNEL_ATTRIBUTE_ATTR).get();
        if (socketType != null) {
            return socketType;
        }
        return -1;
    }

    public static boolean isSupportUDP(int support) {
        return (support & 1) == 1;
    }

    public static boolean isSupportTCP(int support) {
        return (support & 2) == 2;
    }

    public static boolean isSupportWebSocket(int support) {
        return (support & 4) == 4;
    }

    public static boolean isTCPChannel(Channel c) {
        return c != null && Gateway.getSocketType(c) == 2;
    }

    public static boolean isUDPChannel(Channel c) {
        return c != null && Gateway.getSocketType(c) == 1;
    }

    public static boolean isWebSocketChannel(Channel c) {
        return c != null && Gateway.getSocketType(c) == 4;
    }

    public static String $(Channel c) {
        return Gateway.getGatewayFlag(c);
    }

    public static String getGatewayFlag(Channel c) {
        if (Gateway.isUDPChannel(c)) {
            return "udp";
        }
        if (Gateway.isTCPChannel(c)) {
            return "tcp";
        }
        if (Gateway.isWebSocketChannel(c)) {
            return "websocket";
        }
        return "unknow";
    }
}

