/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.utils;

import android.os.Handler;
import android.util.Log;

public abstract class MBSimpleTimer {
    private Handler handler = null;
    private Runnable runnable = null;
    private int interval = -1;

    public MBSimpleTimer(int interval) {
        this.interval = interval;
    }

    public void init() {
        this.handler = new Handler();
        this.runnable = () -> {
            try {
                this.doAction();
            }
            catch (Exception e) {
                Log.w((String)MBSimpleTimer.class.getSimpleName(), (Throwable)e);
            }
            this.handler.postDelayed(this.runnable, (long)this.interval);
        };
    }

    protected abstract void doAction();

    public void start(boolean immediately) {
        this.stop();
        this.onStart();
        this.handler.postDelayed(this.runnable, immediately ? 0L : (long)this.interval);
    }

    protected void onStart() {
    }

    public void stop() {
        this.handler.removeCallbacks(this.runnable);
        this.onStop();
    }

    protected void onStop() {
    }
}

