/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.core;

import android.util.Log;
import net.x52im.mobileimsdk.android.ClientCoreSDK;
import net.x52im.mobileimsdk.android.core.AutoReLoginDaemon;
import net.x52im.mobileimsdk.android.core.KeepAliveDaemon;
import net.x52im.mobileimsdk.android.core.LocalDataSender;
import net.x52im.mobileimsdk.android.core.LocalSocketProvider;
import net.x52im.mobileimsdk.android.core.QoS4ReciveDaemon;
import net.x52im.mobileimsdk.android.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.android.utils.MBThreadPoolExecutor;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.s.PErrorResponse;
import net.x52im.mobileimsdk.server.protocal.s.PKickoutInfo;
import net.x52im.mobileimsdk.server.protocal.s.PLoginInfoResponse;

public class LocalDataReciever {
    private static final String TAG = LocalDataReciever.class.getSimpleName();
    private static LocalDataReciever instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalDataReciever getInstance() {
        if (instance != null) return instance;
        Class<LocalDataReciever> clazz = LocalDataReciever.class;
        synchronized (LocalDataReciever.class) {
            if (instance != null) return instance;
            instance = new LocalDataReciever();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LocalDataReciever() {
        this.init();
    }

    private void init() {
    }

    public void handleProtocal(byte[] fullProtocalOfBody) {
        MBThreadPoolExecutor.runOnMainThread(() -> this.handleProtocalImpl(fullProtocalOfBody));
    }

    private void handleProtocalImpl(byte[] fullProtocalOfBody) {
        if (fullProtocalOfBody == null || fullProtocalOfBody.length == 0) {
            Log.d((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u65e0\u6548\u7684fullProtocalOfBody\uff08null \u6216 .length == 0\uff09\uff01");
            return;
        }
        try {
            Protocal pFromServer = ProtocalFactory.parse((byte[])fullProtocalOfBody, (int)fullProtocalOfBody.length);
            if (pFromServer.isQoS()) {
                if (pFromServer.getType() == 50 && ProtocalFactory.parsePLoginInfoResponse((String)pFromServer.getDataContent()).getCode() != 0) {
                    if (ClientCoreSDK.DEBUG) {
                        Log.d((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u3010BugFIX\u3011\u8fd9\u662f\u670d\u52a1\u7aef\u7684\u767b\u9646\u8fd4\u56de\u54cd\u5e94\u5305\uff0c\u4e14\u670d\u52a1\u7aef\u5224\u5b9a\u767b\u9646\u5931\u8d25(\u5373code!=0)\uff0c\u672c\u6b21\u65e0\u9700\u53d1\u9001ACK\u5e94\u7b54\u5305\uff01");
                    }
                } else {
                    if (QoS4ReciveDaemon.getInstance().hasRecieved(pFromServer.getFp())) {
                        if (ClientCoreSDK.DEBUG) {
                            Log.d((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u3010QoS\u673a\u5236\u3011" + pFromServer.getFp() + "\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d1\u9001\u5217\u8868\u4e2d\uff0c\u8fd9\u662f\u91cd\u590d\u5305\uff0c\u901a\u77e5\u5e94\u7528\u5c42\u6536\u5230\u8be5\u5305\u7f57\uff01"));
                        }
                        QoS4ReciveDaemon.getInstance().addRecieved(pFromServer);
                        this.sendRecievedBack(pFromServer);
                        return;
                    }
                    QoS4ReciveDaemon.getInstance().addRecieved(pFromServer);
                    this.sendRecievedBack(pFromServer);
                }
            }
            switch (pFromServer.getType()) {
                case 2: {
                    this.onRecievedCommonData(pFromServer);
                    break;
                }
                case 51: {
                    this.onServerResponseKeepAlive();
                    break;
                }
                case 4: {
                    this.onMessageRecievedACK(pFromServer);
                    break;
                }
                case 50: {
                    this.onServerResponseLogined(pFromServer);
                    break;
                }
                case 52: {
                    this.onServerResponseError(pFromServer);
                    break;
                }
                case 54: {
                    this.onKickout(pFromServer);
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u6536\u5230\u7684\u670d\u52a1\u7aef\u6d88\u606f\u7c7b\u578b\uff1a" + pFromServer.getType() + "\uff0c\u4f46\u76ee\u524d\u8be5\u7c7b\u578b\u5ba2\u6237\u7aef\u4e0d\u652f\u6301\u89e3\u6790\u548c\u5904\u7406\uff01"));
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u5904\u7406\u6d88\u606f\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u9519\u8bef.", (Throwable)e);
        }
    }

    protected void onRecievedCommonData(Protocal pFromServer) {
        if (ClientCoreSDK.getInstance().getChatMessageEvent() != null) {
            ClientCoreSDK.getInstance().getChatMessageEvent().onRecieveMessage(pFromServer.getFp(), pFromServer.getFrom(), pFromServer.getDataContent(), pFromServer.getTypeu());
        }
    }

    protected void onServerResponseKeepAlive() {
        if (ClientCoreSDK.DEBUG) {
            Log.d((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u6536\u5230\u670d\u52a1\u7aef\u56de\u8fc7\u6765\u7684Keep Alive\u5fc3\u8df3\u54cd\u5e94\u5305.");
        }
        KeepAliveDaemon.getInstance().updateGetKeepAliveResponseFromServerTimstamp();
    }

    protected void onMessageRecievedACK(Protocal pFromServer) {
        String theFingerPrint = pFromServer.getDataContent();
        if (ClientCoreSDK.DEBUG) {
            Log.d((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u3010QoS\u3011\u6536\u5230" + pFromServer.getFrom() + "\u53d1\u8fc7\u6765\u7684\u6307\u7eb9\u4e3a" + theFingerPrint + "\u7684\u5e94\u7b54\u5305."));
        }
        if (ClientCoreSDK.getInstance().getMessageQoSEvent() != null) {
            ClientCoreSDK.getInstance().getMessageQoSEvent().messagesBeReceived(theFingerPrint);
        }
        QoS4SendDaemon.getInstance().remove(theFingerPrint);
    }

    protected void onServerResponseLogined(Protocal pFromServer) {
        PLoginInfoResponse loginInfoRes = ProtocalFactory.parsePLoginInfoResponse((String)pFromServer.getDataContent());
        if (loginInfoRes.getCode() == 0) {
            if (!ClientCoreSDK.getInstance().isLoginHasInit()) {
                ClientCoreSDK.getInstance().saveFirstLoginTime(loginInfoRes.getFirstLoginTime());
            }
            this.fireConnectedToServer();
        } else {
            Log.d((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u767b\u9646\u9a8c\u8bc1\u5931\u8d25\uff0c\u9519\u8bef\u7801=" + loginInfoRes.getCode() + "\uff01"));
            LocalSocketProvider.getInstance().closeLocalSocket();
            ClientCoreSDK.getInstance().setConnectedToServer(false);
        }
        if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
            ClientCoreSDK.getInstance().getChatBaseEvent().onLoginResponse(loginInfoRes.getCode());
        }
    }

    protected void onServerResponseError(Protocal pFromServer) {
        PErrorResponse errorRes = ProtocalFactory.parsePErrorResponse((String)pFromServer.getDataContent());
        if (errorRes.getErrorCode() == 301) {
            ClientCoreSDK.getInstance().setLoginHasInit(false);
            Log.e((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u6536\u5230\u670d\u52a1\u7aef\u7684\u201c\u5c1a\u672a\u767b\u9646\u201d\u7684\u9519\u8bef\u6d88\u606f\uff0c\u5fc3\u8df3\u7ebf\u7a0b\u5c06\u505c\u6b62\uff0c\u8bf7\u5e94\u7528\u5c42\u91cd\u65b0\u767b\u9646.");
            KeepAliveDaemon.getInstance().stop();
            AutoReLoginDaemon.getInstance().start(false);
        }
        if (ClientCoreSDK.getInstance().getChatMessageEvent() != null) {
            ClientCoreSDK.getInstance().getChatMessageEvent().onErrorResponse(errorRes.getErrorCode(), errorRes.getErrorMsg());
        }
    }

    protected void onKickout(Protocal pFromServer) {
        if (ClientCoreSDK.DEBUG) {
            Log.d((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u6536\u5230\u670d\u52a1\u7aef\u53d1\u8fc7\u6765\u7684\u201c\u88ab\u8e22\u201d\u6307\u4ee4.");
        }
        ClientCoreSDK.getInstance().release();
        PKickoutInfo kickoutInfo = ProtocalFactory.parsePKickoutInfo((String)pFromServer.getDataContent());
        if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
            ClientCoreSDK.getInstance().getChatBaseEvent().onKickout(kickoutInfo);
        }
        if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
            ClientCoreSDK.getInstance().getChatBaseEvent().onLinkClose(-1);
        }
    }

    protected void fireConnectedToServer() {
        ClientCoreSDK.getInstance().setLoginHasInit(true);
        AutoReLoginDaemon.getInstance().stop();
        KeepAliveDaemon.getInstance().setNetworkConnectionLostObserver((observable, data) -> this.fireDisconnectedToServer());
        KeepAliveDaemon.getInstance().start(false);
        QoS4SendDaemon.getInstance().startup(true);
        QoS4ReciveDaemon.getInstance().startup(true);
        ClientCoreSDK.getInstance().setConnectedToServer(true);
    }

    protected void fireDisconnectedToServer() {
        ClientCoreSDK.getInstance().setConnectedToServer(false);
        LocalSocketProvider.getInstance().closeLocalSocket();
        QoS4ReciveDaemon.getInstance().stop();
        if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
            ClientCoreSDK.getInstance().getChatBaseEvent().onLinkClose(-1);
        }
        AutoReLoginDaemon.getInstance().start(true);
    }

    private void sendRecievedBack(final Protocal pFromServer) {
        if (pFromServer.getFp() != null) {
            new LocalDataSender.SendCommonDataAsync(ProtocalFactory.createRecivedBack((String)pFromServer.getTo(), (String)pFromServer.getFrom(), (String)pFromServer.getFp(), (boolean)pFromServer.isBridge())){

                @Override
                protected void onPostExecute(Integer code) {
                    if (ClientCoreSDK.DEBUG) {
                        Log.d((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u3010QoS\u3011\u5411" + pFromServer.getFrom() + "\u53d1\u9001" + pFromServer.getFp() + "\u5305\u7684\u5e94\u7b54\u5305\u6210\u529f,from=" + pFromServer.getTo() + "\uff01"));
                    }
                }
            }.execute(new Object[0]);
        } else {
            Log.w((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u3010QoS\u3011\u6536\u5230" + pFromServer.getFrom() + "\u53d1\u8fc7\u6765\u9700\u8981QoS\u7684\u5305\uff0c\u4f46\u5b83\u7684\u6307\u7eb9\u7801\u5374\u4e3anull\uff01\u65e0\u6cd5\u53d1\u5e94\u7b54\u5305\uff01"));
        }
    }
}

