/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import io.netty.channel.Channel;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.core.LocalSocketProvider;
import net.x52im.mobileimsdk.java.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.java.utils.MBObserver;
import net.x52im.mobileimsdk.java.utils.TCPUtils;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;
import org.jdesktop.swingworker.SwingWorker;

public class LocalDataSender {
    private static final String TAG = LocalDataSender.class.getSimpleName();
    private static LocalDataSender instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalDataSender getInstance() {
        if (instance != null) return instance;
        Class<LocalDataSender> clazz = LocalDataSender.class;
        synchronized (LocalDataSender.class) {
            if (instance != null) return instance;
            instance = new LocalDataSender();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LocalDataSender() {
    }

    int sendLogin(final PLoginInfo loginInfo) {
        int codeForCheck = this.checkBeforeSend();
        if (codeForCheck != 0) {
            return codeForCheck;
        }
        if (!LocalSocketProvider.getInstance().isLocalSocketReady()) {
            if (ClientCoreSDK.DEBUG) {
                Log.d(TAG, "\u3010IMCORE-TCP\u3011\u53d1\u9001\u767b\u9646\u6307\u4ee4\u65f6\uff0csocket\u8fde\u63a5\u672a\u5c31\u7eea\uff0c\u9996\u5148\u5f00\u59cb\u5c1d\u8bd5\u53d1\u8d77\u8fde\u63a5\uff08\u767b\u9646\u6307\u4ee4\u5c06\u5728\u8fde\u63a5\u6210\u529f\u540e\u7684\u56de\u8c03\u4e2d\u81ea\u52a8\u53d1\u51fa\uff09\u3002\u3002\u3002\u3002");
            }
            MBObserver connectionDoneObserver = new MBObserver(){

                public void update(boolean sucess, Object extraObj) {
                    if (sucess) {
                        LocalDataSender.this.sendLoginImpl(loginInfo);
                    } else {
                        Log.w(TAG, "\u3010IMCORE-TCP\u3011[\u6765\u81eaNetty\u7684\u8fde\u63a5\u7ed3\u679c\u56de\u8c03\u89c2\u5bdf\u8005\u901a\u77e5]socket\u8fde\u63a5\u5931\u8d25\uff0c\u672c\u6b21\u767b\u9646\u4fe1\u606f\u672a\u6210\u529f\u53d1\u51fa\uff01");
                    }
                }
            };
            LocalSocketProvider.getInstance().setConnectionDoneObserver(connectionDoneObserver);
            return LocalSocketProvider.getInstance().resetLocalSocket() != null ? 0 : 202;
        }
        return this.sendLoginImpl(loginInfo);
    }

    int sendLoginImpl(PLoginInfo loginInfo) {
        byte[] b = ProtocalFactory.createPLoginInfo((PLoginInfo)loginInfo).toBytes();
        int code = this.send(b, b.length);
        if (code == 0) {
            ClientCoreSDK.getInstance().setCurrentLoginInfo(loginInfo);
        }
        return code;
    }

    public int sendLoginout() {
        int code = 0;
        if (ClientCoreSDK.getInstance().isLoginHasInit()) {
            byte[] b = ProtocalFactory.createPLoginoutInfo((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes();
            code = this.send(b, b.length);
        }
        ClientCoreSDK.getInstance().release();
        return code;
    }

    int sendKeepAlive() {
        byte[] b = ProtocalFactory.createPKeepAlive((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes();
        return this.send(b, b.length);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, -1);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, null, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, true, fingerPrint, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, boolean QoS, String fingerPrint, int typeu) {
        return this.sendCommonData(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)QoS, (String)fingerPrint, (int)typeu));
    }

    public int sendCommonData(Protocal p) {
        if (p != null) {
            byte[] b = p.toBytes();
            int code = this.send(b, b.length);
            if (code == 0 && p.isQoS() && !QoS4SendDaemon.getInstance().exist(p.getFp())) {
                QoS4SendDaemon.getInstance().put(p);
            }
            return code;
        }
        return 4;
    }

    public int send(byte[] fullProtocalBytes, int dataLen) {
        int codeForCheck = this.checkBeforeSend();
        if (codeForCheck != 0) {
            return codeForCheck;
        }
        Channel ds = LocalSocketProvider.getInstance().getLocalSocket();
        if (ds != null && ds.isActive()) {
            return TCPUtils.send(ds, fullProtocalBytes, dataLen) ? 0 : 3;
        }
        Log.d(TAG, "\u3010IMCORE-TCP\u3011scocket\u672a\u8fde\u63a5\uff0c\u65e0\u6cd5\u53d1\u9001\uff0c\u672c\u6761\u5c06\u88ab\u5ffd\u7565\uff08dataLen=" + dataLen + "\uff09!");
        return 0;
    }

    private int checkBeforeSend() {
        if (!ClientCoreSDK.getInstance().isInitialed()) {
            return 203;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SendCommonDataAsync
    extends SwingWorker<Integer, Object> {
        protected Protocal p = null;

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id) {
            this(dataContentWidthStr, to_user_id, null, -1);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, int typeu) {
            this(dataContentWidthStr, to_user_id, null, typeu);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
            this(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)true, (String)fingerPrint, (int)typeu));
        }

        public SendCommonDataAsync(Protocal p) {
            if (p == null) {
                Log.w(TAG, "\u3010IMCORE-TCP\u3011\u65e0\u6548\u7684\u53c2\u6570p==null!");
                return;
            }
            this.p = p;
        }

        protected Integer doInBackground() {
            if (this.p != null) {
                return LocalDataSender.getInstance().sendCommonData(this.p);
            }
            return -1;
        }

        protected void done() {
            int code = -1;
            try {
                code = (Integer)this.get();
            }
            catch (Exception e) {
                Log.w(TAG, e.getMessage());
            }
            this.onPostExecute(code);
        }

        protected abstract void onPostExecute(Integer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SendLoginDataAsync
    extends SwingWorker<Integer, Object> {
        protected PLoginInfo loginInfo = null;

        public SendLoginDataAsync(PLoginInfo loginInfo) {
            this.loginInfo = loginInfo;
            ClientCoreSDK.getInstance().init();
        }

        protected Integer doInBackground() {
            int code = LocalDataSender.getInstance().sendLogin(this.loginInfo);
            return code;
        }

        protected void done() {
            int code = -1;
            try {
                code = (Integer)this.get();
            }
            catch (Exception e) {
                Log.w(TAG, e.getMessage());
            }
            this.onPostExecute(code);
        }

        protected void onPostExecute(Integer code) {
            if (code != 0) {
                Log.d(TAG, "\u3010IMCORE-TCP\u3011\u6570\u636e\u53d1\u9001\u5931\u8d25, \u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01");
            }
            this.fireAfterSendLogin(code);
        }

        protected void fireAfterSendLogin(int code) {
        }
    }
}

