/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.swing9patch.utils;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class DragToMove
implements MouseListener,
MouseMotionListener {
    private Component srcCom;
    private Component destCom;
    private int lastX = -1;
    private int lastY = -1;

    public DragToMove(Component srcCom) {
        this(srcCom, null);
    }

    public DragToMove(Component srcCom, Component destCom) {
        this.srcCom = srcCom;
        this.destCom = destCom;
        this.init();
    }

    private void init() {
        this.srcCom.addMouseListener(this);
        this.srcCom.addMouseMotionListener(this);
    }

    private void reset() {
        this.lastX = -1;
        this.lastY = -1;
    }

    public static void apply(Component[] coms) {
        DragToMove.apply(coms, null);
    }

    public static void apply(Component[] coms, Component[] destComs) {
        if (coms != null) {
            boolean destIsParantWindow = destComs == null;
            for (int i = 0; i < coms.length; ++i) {
                if (destIsParantWindow) {
                    new DragToMove(coms[i]);
                    continue;
                }
                new DragToMove(coms[i], destComs[i]);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.srcCom.setCursor(Cursor.getPredefinedCursor(13));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.srcCom.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.reset();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Component win;
        int x = e.getX();
        int y = e.getY();
        int deltaX = x - this.lastX;
        int deltaY = y - this.lastY;
        Component component = win = this.destCom == null ? SwingUtilities.windowForComponent(this.srcCom) : this.destCom;
        if (win != null) {
            this.setLocationImpl(win, deltaX, deltaY);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected void setLocationImpl(Component dest, int deltaX, int deltaY) {
        dest.setLocation((int)(dest.getLocation().getX() + (double)deltaX), (int)(dest.getLocation().getY() + (double)deltaY));
    }

    public static void applyDragToMoveWindow(Component[] coms) {
        DragToMove.applyDragToMoveWindow(coms, null);
    }

    public static void applyDragToMoveWindow(Component[] coms, Component[] destComs) {
        DragToMove.apply(coms, destComs);
    }
}

