/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.swing9patch.toast;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jb2011.ninepatch4j.NinePatch;
import org.jb2011.swing9patch.toast.NPIconFactory;
import org.jb2011.swing9patch.utils.DragToMove;

public class ToastPane
extends JPanel {
    private NinePatch npBackground = null;
    private JComponent content = null;

    public ToastPane() {
        super(new BorderLayout());
        this.initGUI();
    }

    @Override
    public void paintChildren(Graphics g) {
        if (this.npBackground == null) {
            this.npBackground = NPIconFactory.getInstance().getToastBg();
        }
        if (this.npBackground != null) {
            this.npBackground.draw((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintChildren(g);
    }

    protected void initGUI() {
        this.setOpaque(false);
        this.content = this.createContent();
        DragToMove.apply(new Component[]{this.content});
        this.add((Component)this.content, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(19, 20, 28, 20));
    }

    protected JComponent createContent() {
        JLabel lb = new JLabel("");
        lb.setForeground(new Color(230, 230, 230));
        return lb;
    }

    public void setMessage(String message) {
        ((JLabel)this.content).setText(message);
    }

    public JComponent getContent() {
        return this.content;
    }
}

