/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch10_internalframe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jb2011.lnf.beautyeye.ch1_titlepane.BETitlePane;
import org.jb2011.lnf.beautyeye.utils.MySwingUtilities2;
import org.jb2011.lnf.beautyeye.winlnfutils.WinUtils;

public class BEInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;

    public BEInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    public void addNotify() {
        super.addNotify();
        this.updateOptionPaneState();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.wasClosable = this.frame.isClosable();
        this.selectedBackgroundKey = null;
        this.selectedForegroundKey = null;
        this.setOpaque(false);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.wasClosable != this.frame.isClosable()) {
            this.frame.setClosable(this.wasClosable);
        }
    }

    protected void createButtons() {
        super.createButtons();
        Boolean paintActive = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", paintActive);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton.putClientProperty("paintActive", paintActive);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("paintActive", paintActive);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    protected void showSystemMenu() {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new XMetalTitlePaneLayout();
    }

    public void paintComponent(Graphics g) {
        boolean leftToRight = WinUtils.isLeftToRight(this.frame);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = null;
        Color foreground = null;
        Color shadow = null;
        if (isSelected) {
            if (this.selectedBackgroundKey != null) {
                background = UIManager.getColor(this.selectedBackgroundKey);
            }
            if (background == null) {
                background = UIManager.getColor("activeCaption");
            }
            if (this.selectedForegroundKey != null) {
                foreground = UIManager.getColor(this.selectedForegroundKey);
            }
            if (this.selectedShadowKey != null) {
                shadow = UIManager.getColor(this.selectedShadowKey);
            }
            if (shadow == null) {
                shadow = UIManager.getColor("activeCaptionBorder");
            }
            if (foreground == null) {
                foreground = UIManager.getColor("activeCaptionText");
            }
        } else {
            background = UIManager.getColor("inactiveCaption");
            foreground = UIManager.getColor("inactiveCaptionText");
            shadow = UIManager.getColor("inactiveCaptionBorder");
        }
        Insets frameInsets = this.frame.getInsets();
        this.paintTitlePaneImpl(frameInsets, g, width, height, isSelected);
        int titleLength = 0;
        int xOffset = leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset + 2, iconY + 1);
            xOffset += leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = MySwingUtilities2.getFontMetrics(this.frame, g, f);
            int fHeight = fm.getHeight();
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= MySwingUtilities2.stringWidth(this.frame, fm, frameTitle);
            }
            titleLength = MySwingUtilities2.stringWidth(this.frame, fm, frameTitle);
            g.setColor(foreground);
            MySwingUtilities2.drawString(this.frame, g, frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    protected void paintTitlePaneImpl(Insets frameInsets, Graphics g, int width, int height, boolean isSelected) {
        BETitlePane.paintTitlePane(g, frameInsets.left, frameInsets.top, width - frameInsets.left - frameInsets.right, height, isSelected);
    }

    private void updateOptionPaneState() {
        int type = -2;
        boolean closable = this.wasClosable;
        Object obj = this.frame.getClientProperty("JInternalFrame.messageType");
        if (obj == null) {
            return;
        }
        if (obj instanceof Integer) {
            type = (Integer)obj;
        }
        switch (type) {
            case 0: {
                this.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 3: {
                this.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 2: {
                this.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case -1: 
            case 1: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
                closable = false;
                break;
            }
            default: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
            }
        }
        if (closable != this.frame.isClosable()) {
            this.frame.setClosable(closable);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
            super(BEInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                BEInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                BEInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                BEInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            } else if ("JInternalFrame.messageType".equals(prop)) {
                BEInternalFrameTitlePane.this.updateOptionPaneState();
                BEInternalFrameTitlePane.this.frame.repaint();
            }
            super.propertyChange(evt);
        }
    }

    class XMetalTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        XMetalTitlePaneLayout() {
            super(BEInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (BEInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (BEInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (BEInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (BEInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (BEInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (BEInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = BEInternalFrameTitlePane.this.frame.getFontMetrics(BEInternalFrameTitlePane.this.getFont());
            String frameTitle = BEInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? MySwingUtilities2.stringWidth(BEInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = MySwingUtilities2.stringWidth(BEInternalFrameTitlePane.this.frame, fm, String.valueOf(BEInternalFrameTitlePane.this.frame.getTitle().substring(0, 2)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            int fontHeight = fm.getHeight();
            fontHeight += 4;
            Icon icon = BEInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            height = Math.max(fontHeight, iconHeight += 5) + 5;
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = WinUtils.isLeftToRight(BEInternalFrameTitlePane.this.frame);
            int w = BEInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 5;
            int buttonHeight = BEInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = BEInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (BEInternalFrameTitlePane.this.frame.isClosable()) {
                spacing = 4;
                BEInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (BEInternalFrameTitlePane.this.frame.isMaximizable()) {
                spacing = BEInternalFrameTitlePane.this.frame.isClosable() ? 2 : 4;
                BEInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (BEInternalFrameTitlePane.this.frame.isIconifiable()) {
                spacing = BEInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (BEInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                BEInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            BEInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }
}

