/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.protocal;

import com.google.gson.Gson;
import java.util.UUID;
import net.x52im.mobileimsdk.server.protocal.CharsetHelper;

public class Protocal {
    protected boolean bridge = false;
    protected int type = 0;
    protected String dataContent = null;
    protected String from = "-1";
    protected String to = "-1";
    protected String fp = null;
    protected boolean QoS = false;
    protected int typeu = -1;
    protected transient int retryCount = 0;
    protected long sm = -1L;

    public Protocal(int type, String dataContent, String from, String to) {
        this(type, dataContent, from, to, -1);
    }

    public Protocal(int type, String dataContent, String from, String to, int typeu) {
        this(type, dataContent, from, to, false, null, typeu);
    }

    public Protocal(int type, String dataContent, String from, String to, boolean QoS, String fingerPrint) {
        this(type, dataContent, from, to, QoS, fingerPrint, -1);
    }

    public Protocal(int type, String dataContent, String from, String to, boolean QoS, String fingerPrint, int typeu) {
        this.type = type;
        this.dataContent = dataContent;
        this.from = from;
        this.to = to;
        this.QoS = QoS;
        this.typeu = typeu;
        this.fp = QoS && fingerPrint == null ? Protocal.genFingerPrint() : fingerPrint;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDataContent() {
        return this.dataContent;
    }

    public void setDataContent(String dataContent) {
        this.dataContent = dataContent;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFp() {
        return this.fp;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void increaseRetryCount() {
        ++this.retryCount;
    }

    public boolean isQoS() {
        return this.QoS;
    }

    public void setQoS(boolean qoS) {
        this.QoS = qoS;
    }

    public boolean isBridge() {
        return this.bridge;
    }

    public void setBridge(boolean bridge) {
        this.bridge = bridge;
    }

    public int getTypeu() {
        return this.typeu;
    }

    public void setTypeu(int typeu) {
        this.typeu = typeu;
    }

    public long getSm() {
        return this.sm;
    }

    public void setSm(long sm) {
        this.sm = sm;
    }

    public String toGsonString() {
        return new Gson().toJson(this);
    }

    public byte[] toBytes() {
        return CharsetHelper.getBytes(this.toGsonString());
    }

    public Object clone() {
        Protocal cloneP = new Protocal(this.getType(), this.getDataContent(), this.getFrom(), this.getTo(), this.isQoS(), this.getFp());
        cloneP.setBridge(this.bridge);
        cloneP.setTypeu(this.typeu);
        cloneP.setSm(this.sm);
        return cloneP;
    }

    public static long genServerTimestamp() {
        return System.currentTimeMillis();
    }

    public static String genFingerPrint() {
        return UUID.randomUUID().toString();
    }
}

