/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.demo;

import com.eva.epc.widget.HardLayoutPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.core.LocalDataSender;
import net.x52im.mobileimsdk.java.demo.IMClientManager;
import net.x52im.mobileimsdk.java.utils.Log;
import org.jb2011.lnf.beautyeye.ch3_button.BEButtonUI;
import org.jb2011.swing9patch.toast.Toast;

public class MainGUI
extends JFrame {
    private JButton btnLogout = null;
    private JTextField editId = null;
    private JTextField editContent = null;
    private JButton btnSend = null;
    private JLabel viewMyid = null;
    private JTextPane debugPane;
    private JTextPane imInfoPane;
    private SimpleDateFormat hhmmDataFormat = new SimpleDateFormat("HH:mm:ss");

    public MainGUI() {
        this.initViews();
        this.initListeners();
        this.initOthers();
    }

    private void initViews() {
        this.btnLogout = new JButton("\u9000\u51fa\u7a0b\u5e8f");
        this.btnLogout.setUI(new BEButtonUI().setNormalColor(BEButtonUI.NormalColor.red));
        this.btnLogout.setForeground(Color.white);
        this.viewMyid = new JLabel();
        this.viewMyid.setForeground(new Color(255, 0, 255));
        this.viewMyid.setText("\u672a\u767b\u9646");
        this.btnSend = new JButton("\u53d1\u9001\u6d88\u606f");
        this.btnSend.setUI(new BEButtonUI().setNormalColor(BEButtonUI.NormalColor.green));
        this.btnSend.setForeground(Color.white);
        this.editId = new JTextField(20);
        this.editContent = new JTextField(20);
        this.debugPane = new JTextPane();
        this.debugPane.setBackground(Color.black);
        this.debugPane.setCaretColor(Color.white);
        Log.getInstance().setLogDest(this.debugPane);
        this.imInfoPane = new JTextPane();
        JPanel authPane = new JPanel();
        authPane.setLayout(new BoxLayout(authPane, 2));
        authPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        authPane.add(new JLabel("\u72b6\u6001\uff1a"));
        authPane.add(this.viewMyid);
        authPane.add(Box.createHorizontalGlue());
        authPane.add(this.btnLogout);
        HardLayoutPane toPanel = new HardLayoutPane();
        toPanel.addTo(new JLabel("\u5bf9\u65b9\u8d26\u53f7\uff1a"), 1, true);
        toPanel.addTo(this.editId, 1, true);
        toPanel.nextLine();
        toPanel.addTo(new JLabel("\u53d1\u9001\u5185\u5bb9\uff1a"), 1, true);
        toPanel.addTo(this.editContent, 1, true);
        toPanel.nextLine();
        toPanel.addTo(this.btnSend, 4, true);
        toPanel.nextLine();
        HardLayoutPane oprMainPanel = new HardLayoutPane();
        oprMainPanel.addTitledLineSeparator("\u767b\u9646\u8ba4\u8bc1");
        oprMainPanel.addTo(authPane, 1, true);
        oprMainPanel.addTitledLineSeparator("\u6d88\u606f\u53d1\u9001");
        oprMainPanel.addTo(toPanel, 1, true);
        oprMainPanel.addTitledLineSeparator();
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)oprMainPanel, "North");
        JScrollPane imInfoSc = new JScrollPane(this.imInfoPane);
        imInfoSc.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7), imInfoSc.getBorder()));
        imInfoSc.setHorizontalScrollBarPolicy(31);
        leftPanel.add((Component)imInfoSc, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)leftPanel, "West");
        JScrollPane sc = new JScrollPane(this.debugPane);
        sc.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 0, 2), sc.getBorder()));
        sc.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)sc, "Center");
        this.setTitle("MobileIMSDK_UDP\u7248  v6\u6f14\u793a\u5de5\u7a0b - (\u5f53\u524d\u767b\u9646:" + ClientCoreSDK.getInstance().getCurrentLoginInfo().getLoginUserId() + ", \u8ba8\u8bba\u533a:52im.net, QQ\u7fa4:185926912)");
        this.setLocationRelativeTo(null);
        this.setSize(1000, 700);
        this.showIMInfo_green("\u5f53\u524d\u8d26\u53f7\uff1a" + ClientCoreSDK.getInstance().getCurrentLoginInfo().getLoginUserId());
    }

    private void initListeners() {
        this.btnLogout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.doLogout();
                MainGUI.doExit();
            }
        });
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.doSendMessage();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainGUI.this.doLogout();
                MainGUI.doExit();
            }
        });
    }

    private void initOthers() {
        this.refreshMyid();
        IMClientManager.getInstance().getChatMessageListener().setMainGUI(this);
        IMClientManager.getInstance().getBaseEventListener().setMainGUI(this);
        IMClientManager.getInstance().getMessageQoSListener().setMainGUI(this);
    }

    public void refreshMyid() {
        boolean connectedToSer = ClientCoreSDK.getInstance().isConnectedToServer();
        this.viewMyid.setText(connectedToSer ? "\u901a\u4fe1\u6b63\u5e38" : "\u8fde\u63a5\u65ad\u5f00");
    }

    private void doSendMessage() {
        String msg = this.editContent.getText().toString().trim();
        String friendId = this.editId.getText().toString().trim();
        if (msg.length() > 0 && friendId.length() > 0) {
            this.showIMInfo_black("\u6211\u5bf9" + friendId + "\u8bf4\uff1a" + msg);
            new LocalDataSender.SendCommonDataAsync(msg, friendId){

                @Override
                protected void onPostExecute(Integer code) {
                    if (code == 0) {
                        Log.i(MainGUI.class.getSimpleName(), "2\u6570\u636e\u5df2\u6210\u529f\u53d1\u51fa\uff01");
                    } else {
                        MainGUI.this.showToast("\u6570\u636e\u53d1\u9001\u5931\u8d25\u3002\u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01");
                    }
                }
            }.execute();
        } else {
            String s = "\u63a5\u6536\u8005\u8d26\u53f7len=" + friendId.length() + ", \u6d88\u606f\u5185\u5bb9len=" + msg.length() + ", \u53d1\u9001\u6ca1\u6709\u7ee7\u7eed!";
            this.showIMInfo_red(s);
            Log.e(MainGUI.class.getSimpleName(), s);
        }
    }

    public void doLogout() {
        int code = LocalDataSender.getInstance().sendLoginout();
        this.refreshMyid();
        if (code == 0) {
            System.out.println("\u6ce8\u9500\u767b\u9646\u8bf7\u6c42\u5df2\u5b8c\u6210\uff01");
        } else {
            System.out.println("\u6ce8\u9500\u767b\u9646\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002\u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01");
        }
        IMClientManager.getInstance().resetInitFlag();
    }

    public static void doExit() {
        IMClientManager.getInstance().release();
        System.exit(0);
    }

    public void showIMInfo_black(String txt) {
        this.showIMInfo(new Color(0, 0, 0), txt);
    }

    public void showIMInfo_blue(String txt) {
        this.showIMInfo(new Color(0, 0, 255), txt);
    }

    public void showIMInfo_brightred(String txt) {
        this.showIMInfo(new Color(255, 0, 255), txt);
    }

    public void showIMInfo_red(String txt) {
        this.showIMInfo(new Color(255, 0, 0), txt);
    }

    public void showIMInfo_green(String txt) {
        this.showIMInfo(new Color(0, 128, 0), txt);
    }

    public void showIMInfo(Color c, String txt) {
        try {
            Log.append(c, "[" + this.hhmmDataFormat.format(new Date()) + "]" + txt + "\r\n", this.imInfoPane);
            this.imInfoPane.setCaretPosition(this.imInfoPane.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showToast(String text) {
        Toast.showTost(3000, text, new Point((int)this.getLocationOnScreen().getX() + 50, (int)this.getLocationOnScreen().getY() + 400));
    }
}

