/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Timer;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.core.LocalDataSender;
import net.x52im.mobileimsdk.java.utils.Log;

public class KeepAliveDaemon {
    private static final String TAG = KeepAliveDaemon.class.getSimpleName();
    private static KeepAliveDaemon instance = null;
    public static int KEEP_ALIVE_INTERVAL = 3000;
    public static int NETWORK_CONNECTION_TIME_OUT = 10000;
    public static int NETWORK_CONNECTION_TIME_OUT_CHECK_INTERVAL = 2000;
    private boolean keepAliveRunning = false;
    private AtomicLong lastGetKeepAliveResponseFromServerTimstamp = new AtomicLong(0L);
    private Observer networkConnectionLostObserver = null;
    private boolean keepAliveTaskExcuting = false;
    private boolean keepAliveWillStop = false;
    private Timer keepAliveTimer = null;
    private Timer keepAliveTimeoutTimer = null;

    public static KeepAliveDaemon getInstance() {
        if (instance == null) {
            instance = new KeepAliveDaemon();
        }
        return instance;
    }

    private KeepAliveDaemon() {
        this.init();
    }

    private void init() {
        this.keepAliveTimer = new Timer(KEEP_ALIVE_INTERVAL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KeepAliveDaemon.this.doKeepAlive();
            }
        });
        this.keepAliveTimeoutTimer = new Timer(NETWORK_CONNECTION_TIME_OUT_CHECK_INTERVAL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClientCoreSDK.DEBUG) {
                    Log.i(TAG, "\u3010IMCORE-UDP\u3011\u5fc3\u8df3[\u8d85\u65f6\u68c0\u67e5]\u7ebf\u7a0b\u6267\u884c\u4e2d...");
                }
                KeepAliveDaemon.this.doTimeoutCheck();
            }
        });
    }

    private void doKeepAlive() {
        if (!this.keepAliveTaskExcuting) {
            this.keepAliveTaskExcuting = true;
            if (ClientCoreSDK.DEBUG) {
                Log.i(TAG, "\u3010IMCORE-UDP\u3011\u5fc3\u8df3\u5305[\u53d1\u9001]\u7ebf\u7a0b\u6267\u884c\u4e2d...");
            }
            int code = LocalDataSender.getInstance().sendKeepAlive();
            boolean isInitialedForKeepAlive = this.isInitialedForKeepAlive();
            if (isInitialedForKeepAlive) {
                this.lastGetKeepAliveResponseFromServerTimstamp.set(System.currentTimeMillis());
            }
            this.keepAliveTaskExcuting = false;
            if (this.keepAliveWillStop) {
                this.keepAliveTimer.stop();
            }
        }
    }

    private void doTimeoutCheck() {
        long now;
        boolean isInitialedForKeepAlive = this.isInitialedForKeepAlive();
        if (!isInitialedForKeepAlive && (now = System.currentTimeMillis()) - this.lastGetKeepAliveResponseFromServerTimstamp.longValue() >= (long)NETWORK_CONNECTION_TIME_OUT) {
            this.notifyConnectionLost();
            this.keepAliveWillStop = true;
        }
    }

    private boolean isInitialedForKeepAlive() {
        return this.lastGetKeepAliveResponseFromServerTimstamp.longValue() == 0L;
    }

    public void notifyConnectionLost() {
        this.stop();
        if (this.networkConnectionLostObserver != null) {
            this.networkConnectionLostObserver.update(null, null);
        }
    }

    public void stop() {
        if (this.keepAliveTimeoutTimer != null) {
            this.keepAliveTimeoutTimer.stop();
        }
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.stop();
        }
        this.keepAliveRunning = false;
        this.keepAliveWillStop = false;
        this.lastGetKeepAliveResponseFromServerTimstamp.set(0L);
    }

    public void start(boolean immediately) {
        this.stop();
        if (immediately) {
            this.keepAliveTimer.setInitialDelay(0);
        } else {
            this.keepAliveTimer.setInitialDelay(KEEP_ALIVE_INTERVAL);
        }
        this.keepAliveTimer.start();
        if (immediately) {
            this.keepAliveTimeoutTimer.setInitialDelay(0);
        } else {
            this.keepAliveTimeoutTimer.setInitialDelay(NETWORK_CONNECTION_TIME_OUT_CHECK_INTERVAL);
        }
        this.keepAliveTimeoutTimer.start();
        this.keepAliveRunning = true;
        this.keepAliveWillStop = false;
    }

    public boolean isKeepAliveRunning() {
        return this.keepAliveRunning;
    }

    public void updateGetKeepAliveResponseFromServerTimstamp() {
        this.lastGetKeepAliveResponseFromServerTimstamp.set(System.currentTimeMillis());
    }

    public void setNetworkConnectionLostObserver(Observer networkConnectionLostObserver) {
        this.networkConnectionLostObserver = networkConnectionLostObserver;
    }
}

