/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.widget.EDynamicPromptWraper;
import com.eva.epc.widget.util.ColorHelper;
import com.eva.epc.widget.util.MustInputHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class MustInputHelper2 {
    private Vector<JComponent> acionComs = new Vector();
    public static Color mustInputDefaultBgColor = ColorHelper.LIGHT_YELLOW1;
    private boolean needChangeBgColor = false;
    private MustInputHelper.BorderPromptType borderPromptType = MustInputHelper.BorderPromptType.imageBorderPrompt;
    private EDynamicPromptWraper dynamicPromptWraper = null;
    private Component parent = null;

    public MustInputHelper2(Component parent) {
    }

    public MustInputHelper2(Component parent, JComponent[] actionComs) {
        this(parent, actionComs, MustInputHelper.BorderPromptType.imageBorderPrompt, false);
    }

    public MustInputHelper2(Component parent, JComponent[] actionComs, MustInputHelper.BorderPromptType borderPromptType, boolean changeBackgroundColor) {
        this.parent = parent;
        this.borderPromptType = borderPromptType;
        this.needChangeBgColor = changeBackgroundColor;
        if (actionComs != null) {
            int i = 0;
            while (i < actionComs.length) {
                JComponent c = actionComs[i];
                if (c != null) {
                    this.addActionCom(c);
                }
                ++i;
            }
        }
    }

    public EDynamicPromptWraper getDynamicPromptWraper() {
        if (this.dynamicPromptWraper == null) {
            Window parentWindow = null;
            parentWindow = this.parent instanceof Window ? (Window)this.parent : SwingUtilities.getWindowAncestor(this.parent);
            this.dynamicPromptWraper = new EDynamicPromptWraper(parentWindow);
            parentWindow.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    MustInputHelper2.this.dynamicPromptWraper.refreshLocation();
                }
            });
        }
        return this.dynamicPromptWraper;
    }

    public MustInputHelper2 addActionCom(JComponent actionCom) {
        if (!this.acionComs.contains(actionCom)) {
            if (this.needChangeBgColor) {
                actionCom.setBackground(mustInputDefaultBgColor);
            }
            if (this.borderPromptType == MustInputHelper.BorderPromptType.stringBorderPrompt) {
                actionCom.setBorder(MustInputHelper.createDefaultMustInputStringBorder());
            } else if (this.borderPromptType == MustInputHelper.BorderPromptType.imageBorderPrompt) {
                actionCom.setBorder(MustInputHelper.createDefaultMustInputImageBorder());
            } else if (this.borderPromptType == MustInputHelper.BorderPromptType.none) {
                // empty if block
            }
            actionCom.addFocusListener(this.getDynamicPromptWraper().getResponseListener());
            if (actionCom instanceof JTextComponent) {
                ((JTextComponent)actionCom).getDocument().addDocumentListener(this.getDynamicPromptWraper().getResponseListener());
            }
            this.acionComs.add(actionCom);
        }
        return this;
    }

    public MustInputHelper2 cancelActionCom(JComponent actionCom) {
        if (actionCom != null && this.acionComs.indexOf(actionCom) != -1) {
            this.acionComs.remove(actionCom);
            actionCom.removeFocusListener(this.getDynamicPromptWraper().getResponseListener());
            this.checkMustInput();
        }
        return this;
    }

    public void removeAllActionComs() {
        while (this.acionComs.size() > 0) {
            this.cancelActionCom(this.acionComs.get(0));
        }
    }

    public boolean checkMustInput() {
        for (JComponent c : this.acionComs) {
            if (!(c instanceof JTextComponent && ((JTextComponent)c).getText().trim().length() == 0 || c.getInputVerifier() != null && !c.getInputVerifier().verify(c) || c instanceof JComboBox && (((JComboBox)c).getSelectedItem() == null || ((JComboBox)c).getSelectedItem().toString().trim().equals("")) || c instanceof JList && ((JList)c).getSelectedIndex() < 0) && (!(c instanceof JTree) || ((JTree)c).getSelectionPath() != null)) continue;
            this.getDynamicPromptWraper().setDestComToShow(c);
            this.getDynamicPromptWraper().display();
            return false;
        }
        this.getDynamicPromptWraper().hide();
        return true;
    }

    public MustInputHelper.BorderPromptType getBorderPromptType() {
        return this.borderPromptType;
    }

    public void setBorderPromptType(MustInputHelper.BorderPromptType borderPromptType) {
        this.borderPromptType = borderPromptType;
    }

    public boolean isNeedChangeBgColor() {
        return this.needChangeBgColor;
    }

    public void setNeedChangeBgColor(boolean needChangeBgColor) {
        this.needChangeBgColor = needChangeBgColor;
    }
}

