/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.widget.EAction;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;

public class InternalFrameHelper {
    public static void maximizeFrame(JInternalFrame frame) {
        JDesktopPane desktop = frame.getDesktopPane();
        if (frame.getBounds().contains(new Rectangle(0, 0, desktop.getWidth(), desktop.getHeight()))) {
            return;
        }
        try {
            if (frame.isMaximum()) {
                frame.setMaximum(false);
            }
            frame.setMaximum(true);
            Border border = frame.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(frame);
                Rectangle rectangle = frame.getBounds();
                rectangle.translate(-insets.top, -insets.left);
                rectangle.setSize(rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
                frame.setBounds(rectangle);
            }
        }
        catch (PropertyVetoException propertyvetoexception) {
            propertyvetoexception.printStackTrace();
        }
    }

    public static void closeAllFrames(JDesktopPane desktop) {
        JInternalFrame[] ajinternalframe = desktop.getAllFrames();
        int i = 0;
        while (i < ajinternalframe.length) {
            InternalFrameHelper.closeFrame(desktop, ajinternalframe[i]);
            ++i;
        }
    }

    public static void closeFrame(JDesktopPane desktop, JInternalFrame frame) {
        if (frame != null) {
            frame.dispose();
            desktop.remove(frame);
        }
    }

    public static void restoreFrame(JInternalFrame frame) {
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            } else if (frame.isMaximum()) {
                frame.setMaximum(false);
            }
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public static void normalizeFrameSize(JDesktopPane desktop, JInternalFrame frame) {
        frame.pack();
        int i = frame.getWidth();
        int j = frame.getHeight();
        int k = 5;
        int l = 5;
        int i1 = k * 2;
        if (desktop.getWidth() - i1 < i) {
            i = desktop.getWidth() - i1;
        }
        if (desktop.getHeight() - i1 < j) {
            j = desktop.getHeight() - i1;
        } else if ((float)j < (float)desktop.getHeight() / 1.5f) {
            j = (int)((float)desktop.getHeight() / 1.5f);
        }
        JInternalFrame jinternalframe1 = desktop.getSelectedFrame();
        if (jinternalframe1 != null) {
            int j1 = jinternalframe1.getMinimumSize().height;
            int k1 = jinternalframe1.getX() + j1 + i;
            if (k1 <= desktop.getWidth()) {
                k = k1 - i;
            }
            if ((k1 = jinternalframe1.getY() + j1 + j) <= desktop.getHeight()) {
                l = k1 - j;
            }
        }
        frame.setBounds(k, l, i, j);
    }

    public static void showFrame(JDesktopPane desktop, String frameTitle) {
        JInternalFrame[] frames = desktop.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].getTitle().equals(frameTitle)) {
                try {
                    frames[i].setSelected(true);
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            ++i;
        }
    }

    public static class CascadeAllAction
    extends AbstractAction
    implements FrameSizeConstant {
        private JDesktopPane desktop_m;

        public CascadeAllAction(JDesktopPane desktop) {
            super("\u5c42\u53e0(C)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = os.length - 1;
            while (i > -1) {
                try {
                    os[i].setMaximum(true);
                    os[i].setMaximum(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                os[os.length - 1 - i].setBounds(i * CascadeAllAction.SCREENSIZE.width / 30, i * CascadeAllAction.SCREENSIZE.height / 30, CascadeAllAction.DEFAULTSIZE.width, CascadeAllAction.DEFAULTSIZE.height);
                --i;
            }
        }
    }

    public static class CloseAllAction
    extends EAction {
        private JDesktopPane desktop_m;

        public CloseAllAction(JDesktopPane desktop) {
            super("\u5168\u90e8\u5173\u95ed(C)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = 0;
            while (i < os.length) {
                os[i].dispose();
                ++i;
            }
        }
    }

    public static interface FrameSizeConstant {
        public static final int GAP = 30;
        public static final Dimension SCREENSIZE = SwingUtils.getSizeWithScreen(1.0, 1.0);
        public static final Dimension DEFAULTSIZE = SwingUtils.getSizeWithScreen(0.85, 0.8);
    }

    public static class HorizonalTileAllAction
    extends AbstractAction
    implements FrameSizeConstant {
        private JDesktopPane desktop_m;

        public HorizonalTileAllAction(JDesktopPane desktop) {
            super("\u6c34\u5e73\u5e73\u94fa(H)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = 0;
            while (i < os.length) {
                try {
                    os[i].setMaximum(true);
                    os[i].setMaximum(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                os[i].setBounds(0, i * this.desktop_m.getHeight() / os.length, this.desktop_m.getWidth(), this.desktop_m.getHeight() / os.length);
                ++i;
            }
        }
    }

    public static class MinimizeAllAction
    extends EAction {
        private JDesktopPane desktop_m;

        public MinimizeAllAction(JDesktopPane desktop) {
            super("\u5168\u90e8\u6700\u5c0f\u5316(M)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = 0;
            while (i < os.length) {
                try {
                    os[i].setIcon(true);
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static class RestoreAllAction
    extends EAction {
        private JDesktopPane desktop_m;

        public RestoreAllAction(JDesktopPane desktop) {
            super("\u5168\u90e8\u6062\u590d(R)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = 0;
            while (i < os.length) {
                InternalFrameHelper.restoreFrame(os[i]);
                ++i;
            }
        }
    }

    public static class VerticalTileAllAction
    extends AbstractAction {
        private JDesktopPane desktop_m;

        public VerticalTileAllAction(JDesktopPane desktop) {
            super("\u5782\u76f4\u5e73\u94fa(V)");
            this.desktop_m = desktop;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] os = this.desktop_m.getAllFrames();
            int i = 0;
            while (i < os.length) {
                try {
                    os[i].setMaximum(true);
                    os[i].setMaximum(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                os[i].setBounds(i * this.desktop_m.getWidth() / os.length, 0, this.desktop_m.getWidth() / os.length, this.desktop_m.getHeight());
                ++i;
            }
        }
    }
}

