/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicHandler {
    public static void fillColorRect(Rectangle fillArea, Color themeColor, Graphics g, int gradienttype, int fillType, boolean sType, double propotion) {
        if (0.0 < propotion && propotion < 1.0) {
            Graphics2D g2 = (Graphics2D)g;
            Color alpColor = fillType == 0 ? new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), 10) : GraphicHandler.convertColor(themeColor, 100);
            Color salpColor = fillType == 0 ? new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), 200) : GraphicHandler.convertColor(themeColor, 0);
            int x = (int)fillArea.getX();
            int y = (int)fillArea.getY();
            int w = (int)fillArea.getWidth();
            int h = (int)fillArea.getHeight();
            GradientPaint gp = null;
            if (gradienttype == 0) {
                g2.setClip(x, y, w + 1, (int)((double)h * propotion));
                gp = new GradientPaint(x, y, sType ? alpColor : salpColor, x, (float)((double)y + (double)h * propotion), sType ? salpColor : alpColor);
            } else {
                g2.setClip(x, y, (int)((double)w * propotion), h + 1);
                gp = new GradientPaint(x, y, salpColor, (float)((double)x + (double)w * propotion), y, alpColor);
            }
            g2.setPaint(gp);
            g2.fillRect(x, y, w, h);
            if (gradienttype == 0) {
                g2.setClip(x, y + (int)((double)h * propotion), w + 1, (int)((double)h * (1.0 - propotion)) + 1);
                gp = new GradientPaint(x, (float)((double)y + (double)h * propotion), sType ? salpColor : alpColor, x, (float)y + (float)h, sType ? alpColor : salpColor);
            } else {
                g2.setClip(x + (int)((double)w * propotion), y, (int)((double)w * (1.0 - propotion)) + 1, h + 1);
                gp = new GradientPaint((float)((double)x + (double)w * propotion), y, alpColor, (float)x + (float)w, y, salpColor);
            }
            g2.setPaint(gp);
            g2.fillRect(x, y, w, h);
            g2.setClip(null);
        }
    }

    public static Color convertColor(Color c, int delta) {
        return new Color(c.getRed() + delta > 255 ? 255 : (c.getRed() + delta < 0 ? c.getRed() : c.getRed() + delta), c.getGreen() + delta > 255 ? 255 : (c.getGreen() + delta < 0 ? c.getGreen() : c.getGreen() + delta), c.getBlue() + delta > 255 ? 255 : (c.getBlue() + delta < 0 ? c.getBlue() : c.getBlue() + delta));
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicHandler.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicHandler.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicHandler.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicHandler.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicHandler.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (image.getColorModel().equals(GraphicHandler.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicHandler.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage createThumbnailFast(BufferedImage image, int newSize) {
        int height;
        int width = image.getWidth();
        if (width > (height = image.getHeight())) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)width / (float)height;
            width = newSize;
            height = (int)((float)newSize / ratio);
        } else {
            if (newSize >= height) {
                throw new IllegalArgumentException("newSize must be lower than the image height");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)height / (float)width;
            height = newSize;
            width = (int)((float)newSize / ratio);
        }
        BufferedImage temp = GraphicHandler.createCompatibleImage(image, width, height);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage createThumbnailFast(BufferedImage image, int newWidth, int newHeight) {
        if (newWidth >= image.getWidth() || newHeight >= image.getHeight()) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage temp = GraphicHandler.createCompatibleImage(image, newWidth, newHeight);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newSize) {
        int height;
        boolean isWidthGreater;
        int width = image.getWidth();
        boolean bl = isWidthGreater = width > (height = image.getHeight());
        if (isWidthGreater) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
        } else if (newSize >= height) {
            throw new IllegalArgumentException("newSize must be lower than the image height");
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("newSize must be greater than 0");
        }
        float ratioWH = (float)width / (float)height;
        float ratioHW = (float)height / (float)width;
        BufferedImage thumb = image;
        do {
            if (isWidthGreater) {
                if ((width /= 2) < newSize) {
                    width = newSize;
                }
                height = (int)((float)width / ratioWH);
            } else {
                if ((height /= 2) < newSize) {
                    height = newSize;
                }
                width = (int)((float)height / ratioHW);
            }
            BufferedImage temp = GraphicHandler.createCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (newSize != (isWidthGreater ? width : height));
        return thumb;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newWidth, int newHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            BufferedImage temp = GraphicHandler.createCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        return thumb;
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    public static void drawDashedRect2(Graphics g, int x, int y, int w, int h, float depth) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke old = g2.getStroke();
        BasicStroke nw = new BasicStroke(1.0f, 0, 2, 90.0f, new float[]{depth}, depth);
        g2.setStroke(nw);
        g2.drawRect(x, y, w, h);
        g2.setStroke(old);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height, int step) {
        GraphicHandler.drawDashedRect(g, x, y, width, height, step, true, true, true, true);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height, int step, boolean top, boolean left, boolean bottom, boolean right) {
        int drawStep = step == 0 ? 1 : 2 * step;
        int drawLingStep = step == 0 ? 1 : step;
        int vx = x;
        while (vx < x + width) {
            if (top) {
                g.fillRect(vx, y, drawLingStep, 1);
            }
            if (bottom) {
                g.fillRect(vx, y + height - 1, drawLingStep, 1);
            }
            vx += drawStep;
        }
        int vy = y;
        while (vy < y + height) {
            if (left) {
                g.fillRect(x, vy, 1, drawLingStep);
            }
            if (right) {
                g.fillRect(x + width - 1, vy, 1, drawLingStep);
            }
            vy += drawStep;
        }
    }

    public static Color getColor(Color basic, int r, int g, int b) {
        return new Color(GraphicHandler.getColorInt(basic.getRed() + r), GraphicHandler.getColorInt(basic.getGreen() + g), GraphicHandler.getColorInt(basic.getBlue() + b), GraphicHandler.getColorInt(basic.getAlpha()));
    }

    public static Color getColor(Color basic, int r, int g, int b, int a) {
        return new Color(GraphicHandler.getColorInt(basic.getRed() + r), GraphicHandler.getColorInt(basic.getGreen() + g), GraphicHandler.getColorInt(basic.getBlue() + b), GraphicHandler.getColorInt(basic.getAlpha() + a));
    }

    public static int getColorInt(int rgb) {
        return rgb < 0 ? 0 : (rgb > 255 ? 255 : rgb);
    }

    public static void fillCrystalRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc) {
        GraphicHandler.fillCrystalRoundRec(g2, baseColor, x, y, w, h, arc, 10);
    }

    public static void fillCrystalRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc, int colorDelta) {
        Paint oldp = g2.getPaint();
        GradientPaint gp = new GradientPaint(x, y, GraphicHandler.getColor(baseColor, colorDelta, colorDelta, colorDelta), 0.0f, h / 2, baseColor);
        g2.setPaint(gp);
        g2.fillRoundRect(x, y, w, h / 2, arc, arc);
        g2.setPaint(oldp);
        g2.setColor(GraphicHandler.getColor(baseColor, -8, -8, -8));
        g2.fillRoundRect(x, y + h / 2, w, h / 2, arc, arc);
    }

    public static void fillTextureRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc) {
        GraphicHandler.fillTextureRoundRec(g2, baseColor, x, y, w, h, arc, 35);
    }

    public static void fillTextureRoundRec(Graphics2D g2, Color baseColor, int x, int y, int w, int h, int arc, int colorDelta) {
        SwingUtils.setAntiAliasing(g2, true);
        Paint oldpaint = g2.getPaint();
        GradientPaint gp = new GradientPaint(x, y, GraphicHandler.getColor(baseColor, colorDelta, colorDelta, colorDelta), x, y + h, baseColor);
        g2.setPaint(gp);
        g2.fillRoundRect(x, y, w, h, arc, arc);
        g2.setPaint(oldpaint);
        SwingUtils.setAntiAliasing(g2, false);
    }

    public static void draw4RecCorner(Graphics g, int x, int y, int w, int h, int \u03b2, Color c) {
        Color oldColor = g.getColor();
        g.setColor(c);
        g.drawLine(x, y, x + \u03b2, y);
        g.drawLine(x + (w - \u03b2), y, x + w, y);
        g.drawLine(x, y, x, y + \u03b2);
        g.drawLine(x, y + (h - \u03b2), x, y + h);
        g.drawLine(x, y + h, x + \u03b2, y + h);
        g.drawLine(x + (w - \u03b2), y + h, x + w, y + h);
        g.drawLine(x + w, y + h, x + w, y + (h - \u03b2));
        g.drawLine(x + w, y + \u03b2, x + w, y);
        g.setColor(oldColor);
    }

    public static void drawDashedLine(Graphics g, int depth, int x1, int y1, int x2, int y2) {
        int i;
        if (depth <= 0) {
            g.drawLine(x1, y1, x2, y2);
            return;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke old = g2.getStroke();
            BasicStroke nw = new BasicStroke(1.0f, 0, 2, 90.0f, new float[]{depth}, depth);
            g2.setStroke(nw);
            g2.drawLine(x1, y1, x2, y2);
            g2.setStroke(old);
            return;
        }
        if (y1 == y2) {
            i = 0;
            while (i < (x2 - x1) / depth) {
                if (i % 2 == 0) {
                    g.drawLine(x1 + depth * i, y1, x1 + depth * i + depth, y2);
                }
                ++i;
            }
        }
        if (x1 == x2) {
            i = 0;
            while (i < (y2 - y1) / depth) {
                if (i % 2 == 0) {
                    g.drawLine(x1, y1 + depth * i, x2, y1 + depth * i + depth);
                }
                ++i;
            }
        }
    }

    public static void drawMultiStrings(Graphics g, String str, int x, int y) {
        String[] strsByLine = CommonUtils.breakStringByReturnChar(str);
        if (strsByLine != null) {
            int i = 0;
            while (i < strsByLine.length) {
                g.drawString(strsByLine[i], x, y);
                y += g.getFontMetrics().getHeight();
                ++i;
            }
        }
    }

    public static void drawMultiStrings2(Graphics g, String str, int x, int y, int maxPixelWidth) {
        String[] strsByLine = CommonUtils.breakStringByReturnChar(str);
        if (strsByLine != null) {
            String aloneLineStr = null;
            String afterToReviseStr = null;
            int fontHeight = g.getFontMetrics().getHeight();
            int i = 0;
            while (i < strsByLine.length) {
                aloneLineStr = strsByLine[i];
                afterToReviseStr = SwingUtils.truncString(aloneLineStr, g.getFontMetrics(), (float)maxPixelWidth);
                while (!afterToReviseStr.equals(aloneLineStr)) {
                    if (afterToReviseStr.trim().length() > 0) {
                        g.drawString(afterToReviseStr, x, y);
                        y += fontHeight + 1;
                    }
                    aloneLineStr = aloneLineStr.substring(aloneLineStr.indexOf(afterToReviseStr) + afterToReviseStr.length());
                    afterToReviseStr = SwingUtils.truncString(aloneLineStr, g.getFontMetrics(), (float)maxPixelWidth);
                }
                g.drawString(afterToReviseStr, x, y);
                y += fontHeight + 1;
                ++i;
            }
        }
    }
}

