/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.widget.ERender;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

public class TableContentCopyHandler {
    private static TableContentCopyHandler SINGLETON;
    public static final Action tableCopyAction;

    static {
        tableCopyAction = new CopyActionImpl("copy");
    }

    public static void implCopy(JTable table) {
        InputMap keyMap = table.getInputMap(1);
        keyMap.put(KeyStroke.getKeyStroke(67, 2), tableCopyAction.getValue("Name"));
        table.getActionMap().put(tableCopyAction.getValue("Name"), tableCopyAction);
    }

    public static class CopyActionImpl
    extends AbstractAction
    implements UIResource {
        private boolean canAccessSystemClipboard = true;
        private static Object SandboxClipboardKey = new Object();

        public CopyActionImpl(String name) {
            super(name);
            this.detectCopy();
        }

        public TableContentCopyHandler getSingleton() {
            if (SINGLETON == null) {
                SINGLETON = new TableContentCopyHandler();
            }
            return SINGLETON;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JComponent) {
                JTable c = (JTable)src;
                TableContentCopyHandler th = this.getSingleton();
                Clipboard clipboard = this.clipboardHandle(c);
                String name = (String)this.getValue("Name");
                if (clipboard != null && th != null && name != null) {
                    this.copyToClipboard(c, clipboard, 1);
                }
            }
        }

        private Clipboard clipboardHandle(JComponent c) {
            if (this.detectCopy()) {
                return c.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Java Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }

        private boolean detectCopy() {
            if (this.canAccessSystemClipboard) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    try {
                        sm.checkSystemClipboardAccess();
                        return true;
                    }
                    catch (SecurityException se) {
                        this.canAccessSystemClipboard = false;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public void copyToClipboard(JTable comp, Clipboard clip, int action) {
            Transferable t = null;
            int clipboardAction = 1 & action;
            if (clipboardAction != 0 && (t = this.newTransferable(comp)) != null) {
                clip.setContents(t, null);
            }
        }

        protected Transferable newTransferable(JTable c) {
            JTable table = c;
            int[] rows = table.getSelectedRows();
            int[] cols = table.getSelectedColumns();
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < rows.length) {
                int j = 0;
                while (j < cols.length) {
                    int row = rows[i];
                    int col = cols[j];
                    Object obj = table.getValueAt(row, col);
                    Component cellRenderer = table.getCellRenderer(row, col).getTableCellRendererComponent(table, obj, false, false, row, col);
                    if (cellRenderer instanceof ERender) {
                        obj = ((JLabel)cellRenderer).getText();
                    }
                    String val = obj != null ? obj.toString() : "";
                    sb.append(val + "\t");
                    ++j;
                }
                sb.deleteCharAt(sb.length() - 1).append("\n");
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
            return new StringSelection(sb.toString());
        }
    }
}

