/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.common.util.CommonUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class CheckBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    public static final String DEFAULT_VALUE_CHECKED = "1";
    public static final String DEFAULT_VALUE_UNCHECKED = "0";
    protected JCheckBox checkBoxInstance = new JCheckBox();

    public CheckBoxCellEditor() {
        this(null);
    }

    public CheckBoxCellEditor(ActionListener checkBoxActionListener) {
        this.checkBoxInstance.setHorizontalAlignment(0);
        if (checkBoxActionListener != null) {
            this.checkBoxInstance.addActionListener(checkBoxActionListener);
        }
        this.checkBoxInstance.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CheckBoxCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.checkBoxInstance.isSelected() ? DEFAULT_VALUE_CHECKED : DEFAULT_VALUE_UNCHECKED;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value.equals(DEFAULT_VALUE_CHECKED)) {
            this.checkBoxInstance.setSelected(true);
        } else if (value.equals(DEFAULT_VALUE_UNCHECKED) || CommonUtils.isStringEmpty((String)value)) {
            this.checkBoxInstance.setSelected(false);
        }
        return this.checkBoxInstance;
    }
}

