/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.icon;

import com.android.ninepatch.NinePatch;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;

public class NinePatchIcon
implements Icon {
    private int width = 0;
    private int height = 0;
    private NinePatch ninePatch;

    public NinePatchIcon() {
    }

    public NinePatchIcon(int width, int height, URL imageFileUrl) throws Exception {
        this(width, height, NinePatch.load((URL)imageFileUrl, (boolean)false));
    }

    public NinePatchIcon(int width, int height, BufferedImage image) {
        this(width, height, NinePatch.load((BufferedImage)image, (boolean)true, (boolean)false));
    }

    public NinePatchIcon(int width, int height, NinePatch mPatch) {
        this.width = width;
        this.height = height;
        this.ninePatch = mPatch;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.ninePatch != null) {
            Graphics2D g2 = (Graphics2D)g;
            this.ninePatch.draw(g2, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    public NinePatch getNinePatch() {
        return this.ninePatch;
    }

    public void setNinePatch(NinePatch ninePatch) {
        this.ninePatch = ninePatch;
    }

    public void setNinePatch(URL imageFileUrl) throws Exception {
        this.ninePatch = NinePatch.load((URL)imageFileUrl, (boolean)false);
    }

    public void setNinePatch(BufferedImage image) {
        this.ninePatch = NinePatch.load((BufferedImage)image, (boolean)true, (boolean)false);
    }

    public void setIconWidth(int width) {
        this.width = width;
    }

    public void setIconHeight(int height) {
        this.height = height;
    }
}

