/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.border;

import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class ERoundBorder
extends LineBorder
implements UIResource {
    protected ImageIcon rightCornerIcon = null;
    protected String rightCornerStr = null;
    protected Color rightCornerStrColor = Color.red;
    protected boolean rightCornerStrColorBingCom = false;
    public static final Color defaultLineColor = new Color(188, 188, 188);
    protected int arcWidth = 0;

    public ERoundBorder() {
        this(defaultLineColor, 1);
    }

    public ERoundBorder(Color color) {
        this(color, 1);
    }

    public ERoundBorder(int thickness) {
        this(defaultLineColor, thickness);
    }

    public ERoundBorder(Color color, int thickness) {
        super(color, thickness);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets margin = null;
        if (c instanceof AbstractButton) {
            margin = ((AbstractButton)c).getMargin();
        } else if (c instanceof JToolBar) {
            margin = ((JToolBar)c).getMargin();
        } else if (c instanceof JTextComponent) {
            margin = ((JTextComponent)c).getMargin();
        }
        insets.top = (margin != null ? margin.top : 0) + this.thickness;
        insets.left = (margin != null ? margin.left : 0) + this.thickness;
        insets.bottom = (margin != null ? margin.bottom : 0) + this.thickness;
        insets.right = (margin != null ? margin.right : 0) + this.thickness;
        if (this.rightCornerIcon != null || this.rightCornerStr != null) {
            insets.right = insets.right + (this.rightCornerIcon != null ? this.rightCornerIcon.getIconWidth() + 4 : (this.rightCornerStr != null ? 7 : 0));
        }
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Container cp = c.getParent();
        if (cp != null) {
            if (this.rightCornerIcon != null) {
                g.drawImage(this.rightCornerIcon.getImage(), width - this.rightCornerIcon.getIconWidth() - 4, (height - this.rightCornerIcon.getIconHeight()) / 2, this.rightCornerIcon.getIconWidth(), this.rightCornerIcon.getIconHeight(), null);
            } else if (this.rightCornerStr != null) {
                if (!c.isEnabled() && this.rightCornerStrColorBingCom) {
                    g.setColor(Color.gray.brighter());
                } else {
                    g.setColor(this.rightCornerStrColor);
                }
                g.drawString(this.rightCornerStr, width - g.getFontMetrics().stringWidth(this.rightCornerStr) - 2, y + 15);
            }
        }
        g.setColor(this.lineColor);
        int i = 0;
        while (i < this.thickness) {
            g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.arcWidth, this.arcWidth);
            if (this.thickness > 1) {
                g.setColor(GraphicHandler.getColor(g.getColor(), 70, 70, 70, -50));
            }
            ++i;
        }
        g.setColor(oldColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public ERoundBorder setLineColor(Color c) {
        this.lineColor = c;
        return this;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    public ERoundBorder setThickness(int t) {
        this.thickness = t;
        return this;
    }

    public Object clone() {
        ERoundBorder bb = new ERoundBorder(this.getLineColor(), this.getThickness());
        bb.setRightCornerIcon(this.getRightCornerIcon());
        bb.setRightCornerStr(this.rightCornerStr);
        bb.setRightCornerStrColor(this.rightCornerStrColor);
        return bb;
    }

    public String getRightCornerStr() {
        return this.rightCornerStr;
    }

    public ERoundBorder setRightCornerStr(String rightCornerStr) {
        this.rightCornerStr = rightCornerStr;
        return this;
    }

    public ImageIcon getRightCornerIcon() {
        return this.rightCornerIcon;
    }

    public ERoundBorder setRightCornerIcon(ImageIcon rightCornerIcon) {
        this.rightCornerIcon = rightCornerIcon;
        return this;
    }

    public Color getRightCornerStrColor() {
        return this.rightCornerStrColor;
    }

    public void setRightCornerStrColor(Color rightCornerStrColor) {
        this.rightCornerStrColor = rightCornerStrColor;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public ERoundBorder setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
        return this;
    }

    public boolean isRightCornerStrColorBingCom() {
        return this.rightCornerStrColorBingCom;
    }

    public ERoundBorder setRightCornerStrColorBingCom(boolean rightCornerStrColorBingCom) {
        this.rightCornerStrColorBingCom = rightCornerStrColorBingCom;
        return this;
    }
}

