/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.border;

import com.eva.epc.widget.EShadowLine;
import com.eva.epc.widget.border.EDashedBorder;
import com.eva.epc.widget.border.ERoundBorder;
import com.eva.epc.widget.border.EShadowTitledBorder;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class EBorderFactory {
    public static Border createDashedBorder(Color c, boolean top, boolean left, boolean bottom, boolean right) {
        return new EDashedBorder(c, top, left, bottom, right);
    }

    public static Border createDashedBorder(Color color, int thickness, int step, boolean top, boolean left, boolean bottom, boolean right) {
        return new EDashedBorder(color, thickness, step, top, left, bottom, right);
    }

    public static ERoundBorder createRoundRecBorder() {
        return new ERoundBorder();
    }

    public static ERoundBorder createRoundRecBorder(Color c) {
        return new ERoundBorder(c);
    }

    public static Border createRoundRecBorder(Color color, int thickness) {
        return new ERoundBorder(color, thickness);
    }

    public static ERoundBorder createRoundRecBorder(Color color, int thickness, int arcWidth) {
        return new ERoundBorder(color, thickness).setArcWidth(arcWidth);
    }

    public static ERoundBorder createRoundRecBorder(int thickness, int arcWidth) {
        return new ERoundBorder(thickness).setArcWidth(arcWidth);
    }

    public static ERoundBorder createRoundRecBorder(int arcWidth) {
        return new ERoundBorder(1).setArcWidth(arcWidth);
    }

    public static Border createCoolTitledBorder_LIGHTER() {
        return new EShadowTitledBorder(new Color(200, 200, 200), 3, -45, 0.5f, 0.7f);
    }

    public static Border createCoolTitledBorder() {
        return EBorderFactory.createCoolTitledBorder(null, null, null);
    }

    public static Border createCoolTitledBorder(String title) {
        return EBorderFactory.createCoolTitledBorder(title, null, null);
    }

    public static Border createCoolTitledBorder(Color c) {
        return EBorderFactory.createCoolTitledBorder(null, null, c);
    }

    public static Border createCoolTitledBorder(String title, Color c) {
        return EBorderFactory.createCoolTitledBorder(title, null, c);
    }

    public static Border createCoolTitledBorder(String title, ImageIcon icon) {
        return new EShadowTitledBorder().setTitle(title).setTitleIcon(icon);
    }

    public static Border createCoolTitledBorder(String title, ImageIcon icon, Color c) {
        return new EShadowTitledBorder(c).setTitle(title).setTitleIcon(icon);
    }

    public static JComponent createCoolShadowLine() {
        return EBorderFactory.createCoolShadowLine(null);
    }

    public static JComponent createCoolShadowLine(String title) {
        return new EShadowLine().setTitle(title);
    }

    public static JComponent createCoolShadowLineGRAY() {
        return EBorderFactory.createCoolShadowLineGRAY(null);
    }

    public static JComponent createCoolShadowLineGRAY(String title) {
        return EBorderFactory.createCoolShadowLineGRAY(title, null);
    }

    public static JComponent createCoolShadowLineGRAY(String title, Color titleColor) {
        return EBorderFactory.createCoolShadowLineGRAY(title, titleColor, null);
    }

    public static JComponent createCoolShadowLineGRAY(String title, Color titleColor, Color bgColor) {
        return new EShadowLine(Color.gray, new Color(255, 255, 100), new Color(220, 220, 220, 150), 0.6f, 0.06666667f).setTitle(title).setTitleColor(titleColor).setBgColor(bgColor);
    }

    public static JComponent createCoolShadowLine(Color linectColor, Color linebtColor, Color shadeColor, float divf, float linethick, String title) {
        return new EShadowLine(linectColor, linebtColor, shadeColor, divf, linethick).setTitle(title);
    }
}

