/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.util.GraphicHandler;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class RoundPopupFactory
extends PopupFactory {
    private static Robot robot;
    private float alpha;
    private int gap;

    static {
        try {
            robot = new Robot();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RoundPopupFactory() {
        this(1.0f, 5, false);
    }

    public RoundPopupFactory(float alpha, int gap, boolean dh) {
        this.alpha = alpha;
        this.gap = gap;
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        if (contents instanceof JComponent) {
            Dimension dim = contents.getPreferredSize();
            Rectangle bound = new Rectangle(x, y, dim.width + (contents instanceof JPopupMenu ? 2 : 3) * this.gap, dim.height + (contents instanceof JPopupMenu ? 2 : 3) * this.gap);
            BufferedImage backgroundImage = robot.createScreenCapture(bound);
            ((JComponent)contents).setOpaque(false);
            if (contents instanceof JPopupMenu) {
                MenuElement[] mes = ((JPopupMenu)contents).getSubElements();
                int i = 0;
                while (i < mes.length) {
                    if (mes[i] instanceof JMenuItem) {
                        ((JMenuItem)mes[i]).setOpaque(false);
                    }
                    ++i;
                }
            }
            ((JComponent)contents).setBorder(null);
            NonRectangleFrame frame = new NonRectangleFrame(owner, contents, backgroundImage, bound);
            return super.getPopup(owner, frame, x, y);
        }
        return super.getPopup(owner, contents, x, y);
    }

    class NonRectangleFrame
    extends JComponent {
        BufferedImage backgroundImage;
        Rectangle bound;
        BufferedImage sourceImage;
        BufferedImage shadeImage;

        public NonRectangleFrame(Component owner, Component content, BufferedImage backgroundImage, Rectangle bound) {
            this.setLayout(null);
            this.add(content);
            Dimension dim = content.getPreferredSize();
            content.setBounds((bound.width - dim.width - RoundPopupFactory.this.gap) / 2, (bound.height - dim.height - RoundPopupFactory.this.gap) / 2, dim.width, dim.height);
            this.backgroundImage = backgroundImage;
            this.bound = bound;
            this.setSize(new Dimension(bound.width, bound.height));
            this.setPreferredSize(new Dimension(bound.width, bound.height));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.backgroundImage, 0, 0, this);
            if (this.sourceImage == null) {
                this.sourceImage = new BufferedImage(this.bound.width - RoundPopupFactory.this.gap, this.bound.height - RoundPopupFactory.this.gap, 2);
            }
            Graphics ig = this.sourceImage.getGraphics();
            ig.fillRoundRect(0, 0, this.bound.width - RoundPopupFactory.this.gap, this.bound.height - RoundPopupFactory.this.gap, 20, 20);
            ShadowRenderer renderer = new ShadowRenderer((int)((float)RoundPopupFactory.this.gap * 2.0f / 5.0f), 0.3f, Color.BLACK);
            this.shadeImage = renderer.createShadow(this.sourceImage);
            g2.drawImage((Image)this.shadeImage, 0, 0, this);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite oldcomp = g2.getComposite();
            Stroke oldstock = g2.getStroke();
            Paint oldpaint = g2.getPaint();
            g2.setComposite(AlphaComposite.getInstance(3, RoundPopupFactory.this.alpha));
            g2.setColor(new Color(255, 255, 255));
            g2.fillRoundRect(0, 0, this.bound.width - RoundPopupFactory.this.gap, this.bound.height - RoundPopupFactory.this.gap, 4, 4);
            g2.setColor(new Color(196, 196, 196));
            g2.setStroke(new BasicStroke(1.0f, 0, 2));
            g2.drawRoundRect(0, 0, this.bound.width - RoundPopupFactory.this.gap, this.bound.height - RoundPopupFactory.this.gap, 4, 4);
            g2.setComposite(oldcomp);
            g2.setStroke(oldstock);
            g2.setPaint(oldpaint);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.paintChildren(g2);
        }
    }

    public static class ShadowRenderer {
        private int size = 5;
        private float opacity = 0.5f;
        private Color color = new Color(220, 220, 220);

        public ShadowRenderer() {
            this(5, 0.5f, Color.BLACK);
        }

        public ShadowRenderer(int size, float opacity, Color color) {
            this.setSize(size);
            this.setOpacity(opacity);
            this.setColor(color);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color shadowColor) {
            if (shadowColor != null) {
                Color oldColor = this.color;
                this.color = shadowColor;
            }
        }

        public float getOpacity() {
            return this.opacity;
        }

        public void setOpacity(float shadowOpacity) {
            float oldOpacity = this.opacity;
            this.opacity = (double)shadowOpacity < 0.0 ? 0.0f : (shadowOpacity > 1.0f ? 1.0f : shadowOpacity);
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int shadowSize) {
            int oldSize = this.size;
            this.size = shadowSize < 0 ? 0 : shadowSize;
        }

        public BufferedImage createShadow(BufferedImage image) {
            int a;
            int aSum;
            int historyIdx;
            int shadowSize = this.size * 2;
            int srcWidth = image.getWidth();
            int srcHeight = image.getHeight();
            int dstWidth = srcWidth + shadowSize;
            int dstHeight = srcHeight + shadowSize;
            int left = this.size;
            int right = shadowSize - left;
            int yStop = dstHeight - right;
            int shadowRgb = this.color.getRGB() & 0xFFFFFF;
            int[] aHistory = new int[shadowSize];
            BufferedImage dst = new BufferedImage(dstWidth, dstHeight, 2);
            int[] dstBuffer = new int[dstWidth * dstHeight];
            int[] srcBuffer = new int[srcWidth * srcHeight];
            GraphicHandler.getPixels(image, 0, 0, srcWidth, srcHeight, srcBuffer);
            int lastPixelOffset = right * dstWidth;
            float hSumDivider = 1.0f / (float)shadowSize;
            float vSumDivider = this.opacity / (float)shadowSize;
            int[] hSumLookup = new int[256 * shadowSize];
            int i = 0;
            while (i < hSumLookup.length) {
                hSumLookup[i] = (int)((float)i * hSumDivider);
                ++i;
            }
            int[] vSumLookup = new int[256 * shadowSize];
            int i2 = 0;
            while (i2 < vSumLookup.length) {
                vSumLookup[i2] = (int)((float)i2 * vSumDivider);
                ++i2;
            }
            int srcY = 0;
            int dstOffset = left * dstWidth;
            while (srcY < srcHeight) {
                historyIdx = 0;
                while (historyIdx < shadowSize) {
                    aHistory[historyIdx++] = 0;
                }
                aSum = 0;
                historyIdx = 0;
                int srcOffset = srcY * srcWidth;
                int srcX = 0;
                while (srcX < srcWidth) {
                    a = hSumLookup[aSum];
                    dstBuffer[dstOffset++] = a << 24;
                    aSum -= aHistory[historyIdx];
                    aHistory[historyIdx] = a = srcBuffer[srcOffset + srcX] >>> 24;
                    aSum += a;
                    if (++historyIdx >= shadowSize) {
                        historyIdx -= shadowSize;
                    }
                    ++srcX;
                }
                int i3 = 0;
                while (i3 < shadowSize) {
                    a = hSumLookup[aSum];
                    dstBuffer[dstOffset++] = a << 24;
                    aSum -= aHistory[historyIdx];
                    if (++historyIdx >= shadowSize) {
                        historyIdx -= shadowSize;
                    }
                    ++i3;
                }
                ++srcY;
            }
            int x = 0;
            int bufferOffset = 0;
            while (x < dstWidth) {
                aSum = 0;
                historyIdx = 0;
                while (historyIdx < left) {
                    aHistory[historyIdx++] = 0;
                }
                int y = 0;
                while (y < right) {
                    a = dstBuffer[bufferOffset] >>> 24;
                    aHistory[historyIdx++] = a;
                    aSum += a;
                    ++y;
                    bufferOffset += dstWidth;
                }
                bufferOffset = x;
                historyIdx = 0;
                y = 0;
                while (y < yStop) {
                    a = vSumLookup[aSum];
                    dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                    aSum -= aHistory[historyIdx];
                    aHistory[historyIdx] = a = dstBuffer[bufferOffset + lastPixelOffset] >>> 24;
                    aSum += a;
                    if (++historyIdx >= shadowSize) {
                        historyIdx -= shadowSize;
                    }
                    ++y;
                    bufferOffset += dstWidth;
                }
                y = yStop;
                while (y < dstHeight) {
                    a = vSumLookup[aSum];
                    dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                    aSum -= aHistory[historyIdx];
                    if (++historyIdx >= shadowSize) {
                        historyIdx -= shadowSize;
                    }
                    ++y;
                    bufferOffset += dstWidth;
                }
                bufferOffset = ++x;
            }
            GraphicHandler.setPixels(dst, 0, 0, dstWidth, dstHeight, dstBuffer);
            return dst;
        }
    }
}

