/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class EShadowLine
extends JComponent {
    protected Color linectColor;
    protected Color linebtColor;
    protected Color shadeColor;
    protected float divf;
    protected float linethick;
    private String title = null;
    private Color titleColor = null;
    private Color bgColor = null;
    private boolean alignYHead = false;
    private boolean linethickDependentHeight = false;

    public EShadowLine() {
        this(new Color(79, 136, 230), new Color(200, 230, 255), new Color(230, 240, 250, 200), 0.6f, 0.06666667f);
    }

    public EShadowLine(Color linectColor, Color linebtColor, Color shadeColor, float divf, float linethick) {
        this.linectColor = linectColor;
        this.linebtColor = linebtColor;
        this.shadeColor = shadeColor;
        this.divf = divf;
        this.linethick = linethick;
        this.setPreferredSize(new Dimension(100, 15));
        this.setBackground(this.bgColor == null ? UIManager.getColor("Panel.background") : this.bgColor);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        int titleWidth = this.needDrawTitle() ? g2.getFontMetrics().stringWidth(this.title) : 0;
        int startX = titleWidth == 0 ? 0 : titleWidth + 5;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getBackground();
        g2.setColor(color);
        g2.fillRect(startX, 0, this.getWidth() - startX, this.getHeight());
        Rectangle rect = new Rectangle(startX, this.alignYHead ? 0 : (int)(this.divf * (float)this.getHeight()), this.getWidth() - startX, (int)((1.0f - this.divf) * (float)this.getHeight()));
        int lheight = (int)this.linethick;
        if (this.linethickDependentHeight) {
            lheight = (int)(this.linethick * (float)this.getHeight());
        }
        Rectangle rectline = new Rectangle(rect.x, rect.y, rect.width, lheight < 1 ? 1 : lheight);
        g2.setClip(rect);
        GradientPaint gp = new GradientPaint(0.0f, (float)this.getHeight() * (1.0f + this.divf) / 2.0f, this.shadeColor, 0.0f, this.getHeight(), new Color(this.shadeColor.getRed(), this.shadeColor.getGreen(), this.shadeColor.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        gp = new GradientPaint(startX, this.getHeight(), color, this.getWidth() / 2, 0.0f, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        gp = new GradientPaint(this.getWidth(), this.getHeight(), color, this.getWidth() / 2, 0.0f, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setPaint(null);
        g2.setColor(this.linectColor);
        g2.setClip(rectline);
        g2.fill(rectline);
        gp = new GradientPaint(startX, 0.0f, color, this.getWidth() / 2, 0.0f, new Color(this.linebtColor.getRed(), this.linebtColor.getGreen(), this.linebtColor.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rectline.x, rectline.y, rectline.width, rectline.height);
        gp = new GradientPaint((int)(0.96f * (float)this.getWidth()), 0.0f, color, this.getWidth() / 2, 0.0f, new Color(this.linebtColor.getRed(), this.linebtColor.getGreen(), this.linebtColor.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rectline.x, rectline.y, rectline.width, rectline.height);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setClip(null);
        g2.setPaint(oldPaint);
        if (this.needDrawTitle()) {
            g2.setColor(new Color(255, 255, 255));
            g2.drawString(this.title, 1, 14);
            g2.setColor(this.titleColor == null ? this.linectColor : this.titleColor);
            g2.drawString(this.title, 0, 13);
        }
    }

    public boolean needDrawTitle() {
        return this.title != null;
    }

    public String getTitle() {
        return this.title;
    }

    public EShadowLine setTitle(String title) {
        this.title = title;
        return this;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public EShadowLine setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public boolean isAlignYHead() {
        return this.alignYHead;
    }

    public EShadowLine setAlignYHead(boolean alignYHead) {
        this.alignYHead = alignYHead;
        return this;
    }

    public boolean isLinethickDependentHeight() {
        return this.linethickDependentHeight;
    }

    public EShadowLine setLinethickDependentHeight(boolean linethickDependentHeight) {
        this.linethickDependentHeight = linethickDependentHeight;
        return this;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public EShadowLine setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        this.setBackground(bgColor == null ? UIManager.getColor("Panel.background") : bgColor);
        return this;
    }
}

