/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.widget.ERender;
import com.eva.epc.widget.ERenderComboBox;
import com.eva.epc.widget.ESearchableField;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ESearchableComboBox
extends ERenderComboBox {
    private JComponent labelCom = null;

    public ESearchableComboBox() {
        this(new ERender(), ESearchableField.MathLang.mixed);
    }

    public ESearchableComboBox(IdName[] idAndNames) {
        this(idAndNames, ESearchableField.MathLang.mixed);
    }

    public ESearchableComboBox(ERender rdr) {
        this(rdr, ESearchableField.MathLang.mixed);
    }

    public ESearchableComboBox(IdName[] idAndNames, ESearchableField.MathLang searchMatchLang) {
        super(idAndNames);
        this.setEditor(this.createDefaultInput(searchMatchLang));
    }

    public ESearchableComboBox(ERender rdr, ESearchableField.MathLang searchMatchLang) {
        super(rdr);
        this.setEditor(this.createDefaultInput(searchMatchLang));
    }

    protected ESearchableField createDefaultInput(ESearchableField.MathLang searchMatchLang) {
        ESearchableField sf = new ESearchableField(6){

            @Override
            public ArrayList getSearchSourceItems() {
                return ESearchableComboBox.this.getNames();
            }
        };
        sf.setSearchMatchLang(searchMatchLang);
        this.setEditor(sf);
        sf.setOpaque(false);
        return sf;
    }

    @Override
    public String getUIClassID() {
        return "ESearchableComboBoxUI";
    }

    public void setEditor(JTextField textInputEditor) {
        super.setEditable(textInputEditor != null);
        super.setEditor(textInputEditor == null ? null : new TextInputEditor(textInputEditor));
    }

    @Override
    public ESearchableComboBox setLabelCom(JComponent labelCom) {
        this.labelCom = labelCom;
        return this;
    }

    @Override
    public JComponent getLabelCom() {
        return this.labelCom;
    }

    public static class TextInputEditor
    implements ComboBoxEditor {
        protected JTextField editor;
        protected Object item;

        public TextInputEditor(JTextField editor) {
            this.editor = editor;
            editor.setColumns(9);
            editor.setBorder(null);
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                anObject = "";
            }
            this.item = anObject;
            this.editor.setText(anObject.toString());
        }

        @Override
        public Object getItem() {
            if (this.item instanceof String) {
                return this.editor.getText();
            }
            return this.editor.getText().equals(this.item.toString()) ? this.item : "";
        }

        public String getTextItem() {
            return this.editor.getText();
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }
}

