/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.widget.res.IconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EProgessIndicatorPane
extends JPanel {
    private ImageIcon greenPointIcon = IconFactory.getInstance().getProgressIndicator_greenPoint_icon();
    private ImageIcon greenProgressArrowIcon = IconFactory.getInstance().getProgressIndicator_fullGreenProgressArrow_icon();
    private static final int ICON_GAP = 6;
    private int POINT_ICON_WIDTH = this.greenPointIcon.getIconWidth();
    private int POINT_ICON_HEIGHT = this.greenPointIcon.getIconHeight();
    private int PROGRESS_ARROW_ICON_WIDTH = this.greenProgressArrowIcon.getIconWidth();
    private int PROGRESS_ARROW_ICON_HEIGHT = this.greenProgressArrowIcon.getIconHeight();
    private Color darkForegroundColor = new Color(34, 34, 34);
    private Color lightForegroundColor = new Color(153, 153, 153);
    private int statusCount = -1;
    private ArrayList<PointLabel> pointLabels = new ArrayList();
    private ArrayList<ProgressArrowLabel> progressArrowLabels = new ArrayList();
    private ArrayList<BottomDescPane> bottomDescPanes = new ArrayList();

    public EProgessIndicatorPane(IdName ... status) {
        if (status.length < 2) {
            throw new RuntimeException("\u6307\u793a\u9762\u677f\u4e2d\u7684\u72b6\u6001\u6570status.length\u81f3\u5c11\u5e94\u4e3a2\uff0c\u5426\u5219\u6307\u793a\u9762\u677f\u5c31\u65e0\u610f\u4e49\u4e86\u3002");
        }
        this.statusCount = status.length;
        this.initGUI(status);
    }

    private void initGUI(IdName ... status) {
        JPanel bottomPane = new JPanel(new FlowLayout(0));
        int bottomStatusDescGap = this.getBottomStatusDescGap();
        int i = 0;
        IdName[] idNameArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IdName stat = idNameArray[n2];
            BottomDescPane bdl = new BottomDescPane(BottomDescPaneStyle.light, stat.getName().toString());
            bottomPane.add(bdl);
            this.bottomDescPanes.add(bdl);
            if (i < status.length - 1) {
                bottomPane.add(Box.createHorizontalStrut(bottomStatusDescGap));
            }
            ++i;
            ++n2;
        }
        ((FlowLayout)bottomPane.getLayout()).setHgap(0);
        ((FlowLayout)bottomPane.getLayout()).setVgap(0);
        bottomPane.setOpaque(false);
        JPanel centerParentPane = new JPanel();
        centerParentPane.setLayout(new BoxLayout(centerParentPane, 0));
        centerParentPane.add(Box.createHorizontalStrut(this.getCenterIconsWidth() / this.statusCount / 2 - 6 - this.POINT_ICON_WIDTH / 2));
        JPanel centerPane = new JPanel(new FlowLayout(0));
        int j = 0;
        IdName[] idNameArray2 = status;
        int n3 = status.length;
        int n4 = 0;
        while (n4 < n3) {
            IdName stat = idNameArray2[n4];
            PointLabel pl = new PointLabel(PointStyle.gray);
            centerPane.add(pl);
            this.pointLabels.add(pl);
            if (j < status.length - 1) {
                ProgressArrowLabel pal = new ProgressArrowLabel(ProgressArrowStyle.gray);
                centerPane.add(pal);
                this.progressArrowLabels.add(pal);
            }
            ++j;
            ++n4;
        }
        ((FlowLayout)centerPane.getLayout()).setHgap(6);
        ((FlowLayout)centerPane.getLayout()).setVgap(0);
        centerParentPane.add(centerPane);
        centerPane.setOpaque(false);
        centerParentPane.setOpaque(false);
        this.setLayout(new BoxLayout(this, 3));
        this.add(centerParentPane);
        this.add(bottomPane);
        this.setOpaque(false);
    }

    private int getBottomStatusDescGap() {
        return this.PROGRESS_ARROW_ICON_WIDTH + 6 + this.POINT_ICON_WIDTH / 2 + 6 + this.POINT_ICON_WIDTH / 2 - this.getCenterIconsWidth() / this.statusCount;
    }

    private int getCenterIconsWidth() {
        return this.statusCount * 2 * 6 + this.statusCount * this.POINT_ICON_WIDTH + (this.statusCount - 1) * this.PROGRESS_ARROW_ICON_WIDTH;
    }

    public void resetAllStyle() {
        int i = 0;
        while (i < this.pointLabels.size()) {
            this.resetPonitStyle(i);
            ++i;
        }
        i = 0;
        while (i < this.progressArrowLabels.size()) {
            this.resetProgressArrowStyle(i);
            ++i;
        }
        i = 0;
        while (i < this.bottomDescPanes.size()) {
            this.resetBottomPaneStyle(i);
            ++i;
        }
    }

    public void resetPonitStyle(int index) {
        this.pointLabels.get(index).setPointStyle(PointStyle.gray);
    }

    public void resetProgressArrowStyle(int index) {
        this.progressArrowLabels.get(index).setProgressArrowStyle(ProgressArrowStyle.gray);
    }

    public void resetBottomPaneStyle(int index) {
        this.bottomDescPanes.get(index).setBottomStatusStyle(BottomDescPaneStyle.light);
        this.bottomDescPanes.get(index).setBottomDescText("");
    }

    public void setStyleBeforeAnd(int index) {
        this.resetAllStyle();
        if (index >= 0) {
            int i = 0;
            while (i <= index) {
                this.setPointStyle(i, PointStyle.green);
                ++i;
            }
            i = 0;
            while (i < index) {
                this.setProgressArrowStyle(i, ProgressArrowStyle.fullGreen);
                ++i;
            }
            i = 0;
            while (i <= index) {
                this.setBottomStatusStyle(i, BottomDescPaneStyle.dark);
                ++i;
            }
        }
    }

    public void setPointStyle(int index, PointStyle ps) {
        this.pointLabels.get(index).setPointStyle(ps);
    }

    public void setProgressArrowStyle(int index, ProgressArrowStyle pas) {
        this.progressArrowLabels.get(index).setProgressArrowStyle(pas);
    }

    public void setBottomStatusStyle(int index, BottomDescPaneStyle bds) {
        this.bottomDescPanes.get(index).setBottomStatusStyle(bds);
    }

    public void setBottomDescText(int index, String text) {
        this.bottomDescPanes.get(index).setBottomDescText(text);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class BottomDescPane
    extends JPanel {
        private JLabel statusLabel = null;
        private JLabel descLabel = null;

        public BottomDescPane(BottomDescPaneStyle bds, String txt) {
            this.setPreferredSize(new Dimension(EProgessIndicatorPane.this.getCenterIconsWidth() / EProgessIndicatorPane.this.statusCount, 30));
            this.statusLabel = new JLabel();
            this.statusLabel.setHorizontalAlignment(0);
            this.statusLabel.setText(txt);
            this.descLabel = new JLabel();
            this.descLabel.setHorizontalAlignment(0);
            this.descLabel.setForeground(EProgessIndicatorPane.this.lightForegroundColor);
            this.setBottomStatusStyle(bds);
            this.setLayout(new GridLayout(2, 1));
            this.add(this.statusLabel);
            this.add(this.descLabel);
            this.setOpaque(false);
        }

        public void setBottomStatusStyle(BottomDescPaneStyle bds) {
            switch (bds) {
                case dark: {
                    this.statusLabel.setForeground(EProgessIndicatorPane.this.darkForegroundColor);
                    break;
                }
                case light: {
                    this.statusLabel.setForeground(EProgessIndicatorPane.this.lightForegroundColor);
                }
            }
        }

        public void setBottomDescText(String text) {
            this.descLabel.setText(text);
        }
    }

    public static enum BottomDescPaneStyle {
        dark,
        light;

    }

    public class PointLabel
    extends JLabel {
        public PointLabel(PointStyle ps) {
            this.setPreferredSize(new Dimension(EProgessIndicatorPane.this.POINT_ICON_WIDTH, EProgessIndicatorPane.this.POINT_ICON_HEIGHT));
            this.setPointStyle(ps);
        }

        public void setPointStyle(PointStyle ps) {
            switch (ps) {
                case green: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_greenPoint_icon());
                    break;
                }
                case gray: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_grayPoint_icon());
                    break;
                }
                case orange: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_orangePoint_icon());
                }
            }
        }
    }

    public static enum PointStyle {
        green,
        gray,
        orange;

    }

    public class ProgressArrowLabel
    extends JLabel {
        public ProgressArrowLabel(ProgressArrowStyle pas) {
            this.setPreferredSize(new Dimension(EProgessIndicatorPane.this.PROGRESS_ARROW_ICON_WIDTH, EProgessIndicatorPane.this.PROGRESS_ARROW_ICON_HEIGHT));
            this.setProgressArrowStyle(pas);
        }

        public void setProgressArrowStyle(ProgressArrowStyle pas) {
            switch (pas) {
                case fullGreen: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_fullGreenProgressArrow_icon());
                    break;
                }
                case halfGreen: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_halfGreenProgressArrow_icon());
                    break;
                }
                case gray: {
                    this.setIcon(IconFactory.getInstance().getProgressIndicator_grayProgressArrow_icon());
                }
            }
        }
    }

    public static enum ProgressArrowStyle {
        fullGreen,
        halfGreen,
        gray;

    }
}

