/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EImageViewer
extends JPanel {
    public Image theImage;
    private Boolean isZoom = true;
    JScrollPane jsPane = new JScrollPane(this);

    public EImageViewer() {
        this.setPreferredSize(new Dimension(300, 400));
    }

    public EImageViewer(Image image) {
        this.setImageForView(image);
        this.setPreferredSize(new Dimension(300, 400));
    }

    public EImageViewer(byte[] imageDatas) {
        this.setImageForView(imageDatas);
    }

    public JPanel getScrollPane() {
        CheckboxGroup chooseBox = new CheckboxGroup();
        Checkbox actualView = new Checkbox("\u539f\u56fe\u663e\u793a", chooseBox, false);
        Checkbox zoomView = new Checkbox("\u7f29\u653e\u663e\u793a", chooseBox, true);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel checkboxPane = new JPanel();
        checkboxPane.add(actualView);
        checkboxPane.add(zoomView);
        actualView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EImageViewer.this.isZoom = false;
                    EImageViewer.this.setPreferredSize(new Dimension(EImageViewer.this.theImage.getWidth(null), EImageViewer.this.theImage.getHeight(null)));
                    EImageViewer.this.repaint();
                    EImageViewer.this.jsPane.revalidate();
                }
            }
        });
        zoomView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EImageViewer.this.isZoom = true;
                    EImageViewer.this.setPreferredSize(new Dimension(0, 0));
                    EImageViewer.this.repaint();
                    EImageViewer.this.jsPane.revalidate();
                }
            }
        });
        jp.add((Component)checkboxPane, "North");
        jp.add((Component)this.jsPane, "Center");
        this.setPreferredSize(new Dimension(0, 0));
        this.jsPane.revalidate();
        return jp;
    }

    public void setImageForView(byte[] imageDatas) {
        if (imageDatas == null) {
            this.theImage = null;
            return;
        }
        this.setImageForView(new ImageIcon(imageDatas).getImage());
    }

    public void setImageForView(Image image) {
        if (image != null) {
            this.theImage = image;
            if (this.theImage != null) {
                this.setPreferredSize(new Dimension(this.theImage.getWidth(this), this.theImage.getHeight(this)));
            }
        }
    }

    public Image getImage() {
        return this.theImage;
    }

    public byte[] getImageAsBytes() {
        return this.theImage == null ? null : SwingUtils.imageToByte(this.theImage);
    }

    public void setImageForView(File f) {
        ImageIcon x = new ImageIcon(f.getPath());
        Image image = x.getImage();
        this.setImageForView(x.getImage());
        this.repaint();
    }

    @Override
    public void paintChildren(Graphics g) {
        if (this.theImage != null) {
            if (!this.isZoom.booleanValue()) {
                int imgW = this.theImage.getWidth(null);
                int imgH = this.theImage.getHeight(null);
                double paneW = this.getSize().getWidth();
                double paneH = this.getSize().getHeight();
                g.drawImage(this.theImage, ((int)paneW - imgW) / 2, ((int)paneH - imgH) / 2, imgW, imgH, null);
            } else {
                int y;
                int x;
                int w;
                int h;
                double paneH;
                int imgW = this.theImage.getWidth(null);
                int imgH = this.theImage.getHeight(null);
                double img_w_h_rate = (double)imgW / (double)imgH;
                double paneW = this.getSize().getWidth();
                double pane_w_h_rate = paneW / (paneH = this.getSize().getHeight());
                if (pane_w_h_rate >= img_w_h_rate) {
                    h = (int)paneH;
                    w = (int)((double)h * img_w_h_rate);
                    x = ((int)this.getSize().getWidth() - w) / 2;
                    y = 0;
                } else {
                    w = (int)paneW;
                    h = (int)((double)w / img_w_h_rate);
                    x = 0;
                    y = ((int)this.getSize().getHeight() - h) / 2;
                }
                g.drawImage(this.theImage, x, y, w, h, null);
            }
        }
        super.paintChildren(g);
    }

    public Boolean getIsZoom() {
        return this.isZoom;
    }

    public void setIsZoom(Boolean isZoom) {
        this.isZoom = isZoom;
    }
}

