/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class EGradientPane
extends JPanel {
    private Color color1 = null;
    private Color color2 = null;
    public static final int H_PAINT = 1;
    public static final int V_PAINT = 2;
    public static final int NE_PAINT = 3;
    private int orient = -1;
    private boolean crystalPaint = false;

    public EGradientPane(JComponent com, Color color1, Color color2, int orient, boolean crystalPaint) {
        this.color1 = color1;
        this.color2 = color2;
        this.orient = orient;
        this.crystalPaint = crystalPaint;
        if (com != null) {
            com.setOpaque(false);
            this.add(com);
        }
    }

    public EGradientPane(Color color1, Color color2, int orient, boolean crystalPaint) {
        this(null, color1, color2, orient, crystalPaint);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isOpaque()) {
            return;
        }
        Color control = UIManager.getColor("control");
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (this.crystalPaint) {
            GraphicHandler.fillColorRect(new Rectangle(0, 0, width, height), this.color1, g2, 0, 1, true, 0.92);
        } else {
            Paint storedPaint = g2.getPaint();
            if (this.orient == 1) {
                g2.setPaint(new GradientPaint(0.0f, height / 2, this.color1, width, height / 2, this.color2));
            } else if (this.orient == 2) {
                g2.setPaint(new GradientPaint(width / 2, 0.0f, this.color1, width / 2, height, this.color2));
            } else if (this.orient == 3) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, this.color1, width, height, this.color2));
            }
            g2.fillRect(0, 0, width, height);
            g2.setPaint(storedPaint);
        }
    }

    public static JPanel createPane(JComponent com, Color color1, Color color2, int orient, boolean crystalPaint) {
        return new EGradientPane(com, color1, color2, orient, crystalPaint);
    }

    public static JPanel createPane(Color color1, Color color2, int orient, boolean crystalPaint) {
        return new EGradientPane(color1, color2, orient, crystalPaint);
    }
}

