/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.lnf.nimbuslike.NLPanelUI;
import com.eva.epc.widget.EDateField;
import com.eva.epc.widget.border.EBorderFactory;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.text.DateDocument;
import com.eva.epc.widget.util.ColorHelper;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class EDatePicker
extends JPanel {
    private static Border defaultBSelected = EBorderFactory.createDashedBorder(Color.white, 1, 2, true, false, true, false);
    private static Border defaultBorderUnselected = new EmptyBorder(defaultBSelected.getBorderInsets(new JLabel()));
    private static Font defaultBigFont = new Font("\u5b8b\u4f53", 1, 16);
    private static Font defaultSmallCNFont = new Font("\u5b8b\u4f53", 0, 14);
    private static Font defaultSmallENFont = new Font("\u5b8b\u4f53", 0, 14);
    private Calendar theDateModel = null;
    private JLabel lbTodayTopCenter;
    private JLabel lbTodayBottom = null;
    private JPanel daysPane = null;
    private MouseListener dayCellListener = null;
    private boolean supportDateChangeListener = false;
    private Date currentSelectedDay = null;
    private JComboBox comMonths = null;
    private JComboBox comYears = null;
    private static EDatePicker single = null;
    private static JDialog parentDialog = null;
    private static JTextComponent bindedTextCom = null;
    private static String datePattern = null;
    protected Color defaultBgColorSelected;
    protected Color defaultFColorSelected;
    protected Color defaultBgColor;
    protected Color defaultFColor;
    protected EventListenerList listenerList = new EventListenerList();

    public static EDatePicker getSingleInstance(JTextField text) {
        return EDatePicker.getSingleInstance(text, null, null);
    }

    public static EDatePicker getSingleInstance(JTextComponent text, String Pattern2) {
        return EDatePicker.getSingleInstance(text, Pattern2, null);
    }

    public static EDatePicker getSingleInstance(JTextComponent bindedTextCom, String datePattern, Date selectedDate) {
        EDatePicker.datePattern = datePattern == null ? DateDocument.DEFAULT_DATE_PATTERN : datePattern;
        EDatePicker.bindedTextCom = bindedTextCom;
        if (single == null) {
            single = selectedDate == null ? new EDatePicker() : new EDatePicker(selectedDate);
        }
        single.setSelectedDate(selectedDate);
        return single;
    }

    private EDatePicker() {
        this(new Date());
    }

    private EDatePicker(Date selectedDate) {
        this.currentSelectedDay = selectedDate;
        this.theDateModel = Calendar.getInstance();
        this.theDateModel.setTime(selectedDate);
        this.initGUI();
        this.dayCellListener = this.createDayCellListener();
        this.lbTodayTopCenter.addMouseListener(this.createSkipRoverListener());
        SwingUtils.addHandCursorStyle(this.lbTodayTopCenter);
        this.lbTodayTopCenter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    EDatePicker.this.fireDateChanged(new ChangeEvent(EDatePicker.this.theDateModel.getTime()));
                }
            }
        });
        this.lbTodayBottom.addMouseListener(this.dayCellListener);
        SwingUtils.addHandCursorStyle(this.lbTodayBottom);
        this.addDateChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (bindedTextCom == null) {
                    return;
                }
                if (!(e.getSource() instanceof String)) {
                    Date selectedDate = (Date)e.getSource();
                    SimpleDateFormat f = new SimpleDateFormat(datePattern);
                    if (bindedTextCom instanceof EDateField) {
                        ((EDateField)bindedTextCom).setTextEx(f.format(selectedDate));
                    } else {
                        bindedTextCom.setText(f.format(selectedDate));
                    }
                }
                parentDialog.setVisible(false);
            }
        });
        this.refreshComboxSelected();
    }

    protected void initGUI() {
        this.defaultBgColorSelected = UIManager.getColor("ComboBox.selectionBackground");
        this.defaultFColorSelected = UIManager.getColor("ComboBox.selectionForeground");
        this.defaultBgColor = UIManager.getColor("ComboBox.background");
        this.defaultFColor = ColorHelper.DARK_GRAY1_LIKE_APPLE;
        JPanel pNorth = new JPanel();
        pNorth.setUI(new NLPanelUI(ColorHelper.DARK_ORAGE));
        pNorth.setLayout(new BoxLayout(pNorth, 0));
        pNorth.setForeground(Color.white);
        pNorth.setPreferredSize(new Dimension(1, 25));
        pNorth.setToolTipText("\u53f3\u51fb\u9009\u62e9\u6708");
        JLabel lbSubstractYear = this.createSkipButton(1, -1);
        lbSubstractYear.setText("<<\u5e74");
        lbSubstractYear.setToolTipText("\u70b9\u51fb\u5e74\u6570\u51cf\u4e00");
        pNorth.add(Box.createHorizontalStrut(12));
        pNorth.add(lbSubstractYear);
        pNorth.add(Box.createHorizontalStrut(12));
        JLabel lbSubstractMonth = this.createSkipButton(2, -1);
        lbSubstractMonth.setText("<\u6708 ");
        lbSubstractMonth.setToolTipText("\u70b9\u51fb\u6708\u6570\u51cf\u4e00");
        pNorth.add(lbSubstractMonth);
        this.lbTodayTopCenter = new JLabel("", 0);
        this.lbTodayTopCenter.setFont(defaultBigFont);
        this.lbTodayTopCenter.setForeground(Color.white);
        pNorth.add(Box.createHorizontalGlue());
        pNorth.add(this.lbTodayTopCenter);
        this.lbTodayTopCenter.setToolTipText("\u70b9\u51fb\u9009\u4e2d\u5e74\u6708");
        pNorth.add(Box.createHorizontalGlue());
        JLabel lbAddMonth = this.createSkipButton(2, 1);
        lbAddMonth.setText(" \u6708>");
        lbAddMonth.setToolTipText("\u70b9\u51fb\u6708\u6570\u52a0\u4e00");
        pNorth.add(lbAddMonth);
        JLabel lbAddYear = this.createSkipButton(1, 1);
        lbAddYear.setText("\u5e74>>");
        lbAddYear.setToolTipText("\u70b9\u51fb\u5e74\u6570\u52a0\u4e00");
        pNorth.add(Box.createHorizontalStrut(12));
        pNorth.add(lbAddYear);
        pNorth.add(Box.createHorizontalStrut(12));
        this.comMonths = this.createMonthComboBox();
        int year = this.theDateModel.get(1);
        this.comYears = this.createYearComBox(year - 10, year + 10);
        pNorth.add(this.comYears);
        pNorth.add(this.comMonths);
        JPanel pWeeks = new JPanel(new GridLayout(0, 7));
        pWeeks.setBackground(this.defaultBgColor);
        pWeeks.setOpaque(true);
        DateFormatSymbols sy = new DateFormatSymbols(Locale.getDefault());
        String[] strWeeks = sy.getShortWeekdays();
        int i = 0;
        while (i < 7) {
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            label.setForeground(new Color(0, 80, 231));
            label.setText(strWeeks[i + 1]);
            label.setFont(defaultSmallCNFont);
            pWeeks.add(label);
            ++i;
        }
        this.daysPane = new JPanel(new GridLayout(0, 7));
        this.daysPane.setBorder(new TopBottomLineBorder(ColorHelper.DARK_GRAY1_LIKE_APPLE));
        this.daysPane.setBackground(this.defaultBgColor);
        this.daysPane.setOpaque(true);
        JPanel pCenter = new JPanel(new BorderLayout());
        pCenter.setBackground(this.defaultBgColor);
        pCenter.setOpaque(true);
        pCenter.add((Component)pWeeks, "North");
        pCenter.add((Component)this.daysPane, "Center");
        this.lbTodayBottom = new EDayCell(new Date(), false);
        this.lbTodayBottom.setForeground(this.defaultFColor);
        this.lbTodayBottom.setFont(defaultSmallCNFont);
        this.lbTodayBottom.setHorizontalAlignment(0);
        JPanel pSouth = new JPanel(new BorderLayout());
        pSouth.setUI(new NLPanelUI());
        pSouth.setForeground(this.defaultFColor);
        pSouth.add((Component)this.lbTodayBottom, "Center");
        this.setPreferredSize(new Dimension(380, 180));
        this.setForeground(this.defaultFColor);
        this.setBackground(this.defaultBgColor);
        this.setBorder(BorderFactory.createLineBorder(new Color(243, 243, 243)));
        this.setLayout(new BorderLayout());
        this.add("North", pNorth);
        this.add("Center", pCenter);
        this.add("South", pSouth);
        parentDialog = new JDialog(JOptionPane.getRootFrame(), "\u8bf7\u9009\u62e9\u4f60\u8981\u7684\u65e5\u671f", true);
        parentDialog.getContentPane().add(this);
        parentDialog.pack();
        parentDialog.setResizable(false);
    }

    public void showWindow() {
        Point currentPoint = bindedTextCom.getLocationOnScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = currentPoint.getX() + (double)parentDialog.getWidth() > screenSize.getWidth() ? (int)screenSize.getWidth() - parentDialog.getWidth() : (int)currentPoint.getX();
        int y = currentPoint.getY() + (double)bindedTextCom.getHeight() + (double)parentDialog.getHeight() > screenSize.getHeight() ? (int)screenSize.getHeight() - parentDialog.getHeight() : (int)currentPoint.getY() + bindedTextCom.getHeight();
        parentDialog.setLocation(x, y);
        parentDialog.setVisible(true);
    }

    public void refreshComboxSelected() {
        this.comMonths.setSelectedItem(new IdName(this.theDateModel.get(2), ""));
        this.comYears.setSelectedItem(new IdName(this.theDateModel.get(1), ""));
    }

    protected JComboBox createMonthComboBox() {
        JComboBox<IdName> popupMenu = new JComboBox<IdName>();
        DateFormatSymbols sy = new DateFormatSymbols(Locale.getDefault());
        String[] strMonthes = sy.getShortMonths();
        int i = 0;
        while (i < strMonthes.length - 1) {
            IdName in = new IdName(i, strMonthes[i]);
            popupMenu.addItem(in);
            ++i;
        }
        popupMenu.addItemListener(this.createComboxListener(2));
        return popupMenu;
    }

    protected JComboBox createYearComBox(int start, int end) {
        if (start < 0 || end < 0) {
            return null;
        }
        JComboBox<IdName> popupMenu = new JComboBox<IdName>();
        int i = start;
        while (i <= end) {
            IdName in = new IdName(i, String.valueOf(i));
            popupMenu.addItem(in);
            ++i;
        }
        popupMenu.addItemListener(this.createComboxListener(1));
        return popupMenu;
    }

    protected ItemListener createComboxListener(final int field) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IdName in = (IdName)e.getItem();
                EDatePicker.this.theDateModel.add(field, (Integer)in.getId() - EDatePicker.this.theDateModel.get(field));
                EDatePicker.this.refreshDayPane();
            }
        };
    }

    protected JLabel createSkipButton(int field, int amount) {
        JLabel label = new JLabel();
        label.setFont(defaultBigFont);
        label.setBorder(defaultBorderUnselected);
        label.setBackground(new Color(0, 0, 128));
        label.setForeground(Color.white);
        label.setRequestFocusEnabled(false);
        label.addMouseListener(this.createSkipListener(field, amount));
        label.addMouseListener(this.createSkipRoverListener());
        SwingUtils.addHandCursorStyle(label);
        return label;
    }

    protected MouseListener createSkipListener(final int field, final int amount) {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    EDatePicker.this.theDateModel.add(field, amount);
                    if (field == 1) {
                        IdName inFirst = (IdName)EDatePicker.this.comYears.getItemAt(0);
                        IdName inLast = (IdName)EDatePicker.this.comYears.getItemAt(EDatePicker.this.comYears.getItemCount() - 1);
                        int currentSelectedYear = EDatePicker.this.theDateModel.get(1);
                        if (currentSelectedYear < CommonUtils.getIntValue(inFirst.getId())) {
                            EDatePicker.this.comYears.insertItemAt(new IdName(currentSelectedYear, currentSelectedYear), 0);
                        } else if (currentSelectedYear > CommonUtils.getIntValue(inLast.getId())) {
                            EDatePicker.this.comYears.insertItemAt(new IdName(currentSelectedYear, currentSelectedYear), EDatePicker.this.comYears.getItemCount());
                        }
                    }
                    EDatePicker.this.refreshComboxSelected();
                }
            }
        };
    }

    protected MouseAdapter createSkipRoverListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JComponent com = (JComponent)e.getComponent();
                com.setBorder(defaultBSelected);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JComponent com = (JComponent)e.getComponent();
                com.setBorder(defaultBorderUnselected);
            }
        };
    }

    protected void refreshDayPane() {
        this.lbTodayTopCenter.setText(new SimpleDateFormat(DateDocument.DEFAULT_YEAR$MONTH_PATTERN).format(this.theDateModel.getTime()));
        this.daysPane.removeAll();
        Calendar selectedCalendar = Calendar.getInstance();
        selectedCalendar.setTime(this.currentSelectedDay);
        Calendar setupCalendar = (Calendar)this.theDateModel.clone();
        setupCalendar.set(5, 1);
        int first = setupCalendar.get(7);
        setupCalendar.add(5, -first);
        boolean isCurrentMonth = false;
        int i = 0;
        while (i < 42) {
            setupCalendar.add(5, 1);
            EDayCell label = new EDayCell(setupCalendar.getTime());
            label.setForeground(this.defaultFColor);
            label.addMouseListener(this.dayCellListener);
            if ("1".equals(label.getText())) {
                isCurrentMonth = !isCurrentMonth;
            }
            label.setEnabled(isCurrentMonth);
            if (setupCalendar.get(1) == selectedCalendar.get(1) && setupCalendar.get(2) == selectedCalendar.get(2) && setupCalendar.get(5) == selectedCalendar.get(5)) {
                label.setBorder(new LineBorder(this.defaultBgColorSelected, 1));
            }
            label.setFont(defaultSmallENFont);
            SwingUtils.addHandCursorStyle(label);
            this.daysPane.add(label);
            ++i;
        }
        this.daysPane.validate();
    }

    protected MouseListener createDayCellListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                EDayCell com = (EDayCell)e.getComponent();
                if (EDatePicker.this.isEnabled()) {
                    com.setOpaque(false);
                    com.setBackground(EDatePicker.this.defaultBgColor);
                    com.setForeground(EDatePicker.this.defaultFColor);
                }
                EDatePicker.this.supportDateChangeListener = true;
                EDatePicker.this.setSelectedDate(com.getDate());
                EDatePicker.this.supportDateChangeListener = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (EDatePicker.this.isEnabled()) {
                    JComponent com = (JComponent)e.getComponent();
                    com.setOpaque(true);
                    com.setBackground(EDatePicker.this.defaultBgColorSelected);
                    com.setForeground(EDatePicker.this.defaultFColorSelected);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (EDatePicker.this.isEnabled()) {
                    JComponent com = (JComponent)e.getComponent();
                    com.setOpaque(false);
                    com.setBackground(EDatePicker.this.defaultBgColor);
                    com.setForeground(EDatePicker.this.defaultFColor);
                }
            }
        };
    }

    public void addDateChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeDateChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireDateChanged(ChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
    }

    public void setSelectedDate(Date selectedDate) {
        if (selectedDate == null) {
            return;
        }
        this.currentSelectedDay = selectedDate;
        this.theDateModel.setTime(selectedDate);
        this.refreshDayPane();
        if (this.supportDateChangeListener) {
            this.fireDateChanged(new ChangeEvent(selectedDate));
        }
    }

    public Date getSelectedDate() {
        return this.currentSelectedDay;
    }

    public static class EDayCell
    extends JLabel {
        private Date theDate = null;
        private ImageIcon theIcon = null;
        final SimpleDateFormat theFormat = new SimpleDateFormat(DateDocument.DEFAULT_DATE_PATTERN);
        final SimpleDateFormat dayFormat = new SimpleDateFormat("d");

        public EDayCell(Date date) {
            this(date, true);
        }

        public EDayCell(Date date, boolean isSmallLabel) {
            this.setPreferredSize(new Dimension(40, 20));
            this.setToolTipText(this.theFormat.format(date));
            this.theDate = date;
            if (isSmallLabel) {
                this.setHorizontalAlignment(0);
                this.setText(this.dayFormat.format(date));
                Date d = new Date();
                if (this.theFormat.format(date).equals(this.theFormat.format(d))) {
                    this.theIcon = IconFactory.getInstance().getCalendarTodayIcon();
                }
            } else {
                this.setText(" \u5f53\u524d\u65e5\u671f: " + this.theFormat.format(new Date()));
                this.setIcon(IconFactory.getInstance().getCalendarTodayIcon());
                this.setHorizontalAlignment(2);
            }
        }

        public Date getDate() {
            return this.theDate;
        }

        public void setDate(Date date) {
            this.theDate = date;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.theIcon != null && this.isEnabled()) {
                int x = (this.getWidth() - this.theIcon.getIconWidth()) / 2;
                int y = (this.getHeight() - this.theIcon.getIconHeight()) / 2;
                this.theIcon.paintIcon(this, g, x, y);
            }
        }
    }

    public class TopBottomLineBorder
    extends AbstractBorder {
        private Color lineColor;

        public TopBottomLineBorder(Color color) {
            this.lineColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.lineColor);
            g.drawLine(4, 0, c.getWidth() - 8, 0);
            g.drawLine(4, 1, c.getWidth() - 8, 1);
            g.drawLine(4, c.getHeight() - 1, c.getWidth() - 8, c.getHeight() - 1);
        }
    }
}

