/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.calendar.ChineseCalendar;
import com.eva.epc.widget.EAction;
import com.eva.epc.widget.EDatePicker;
import com.eva.epc.widget.ETextFieldRoot;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.text.DateDocument;
import com.eva.epc.widget.text.FocusGainedImpl;
import com.eva.epc.widget.text.ValidVerifier;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.text.Document;

public class EDateField
extends ETextFieldRoot {
    private JComponent labelCom = null;
    private static final String COMPONENT_NAME_DATE$PICK$BUTTON = "DatePickButton";

    public EDateField() {
        this(null, 12);
    }

    public EDateField(String pattern) {
        this(null, 12);
        this.getDocument().setPattern(pattern);
    }

    public EDateField(int columns) {
        this(null, columns);
    }

    public EDateField(SimpleDateFormat dateFormat) {
        this(null, 12);
        this.getDocument().setPattern(dateFormat.toPattern());
    }

    public EDateField(String text, int columns) {
        super(text, columns);
        this.addFocusListener(FocusGainedImpl.SINGLETON);
        this.addClickAction();
        SwingUtils.addUndoRedo(this);
    }

    @Override
    protected JComponent[] getExtraComponents() {
        return new JComponent[]{this.createExtraToolTipButton(), this.createExtraDatePickButton()};
    }

    protected AbstractButton createExtraDatePickButton() {
        AbstractButton c = SwingUtils.createIconButton(this.createExtraDatePickAction());
        c.setName(COMPONENT_NAME_DATE$PICK$BUTTON);
        return c;
    }

    protected Action createExtraDatePickAction() {
        return new EAction("", IconFactory.getInstance().getCalendarIcon16_16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                EDateField.this.fireExtraDatePickAction();
            }
        }.setTooltip("\u70b9\u51fb\u5f39\u51fa\u65e5\u671f\u9009\u62e9\u9762\u677f.");
    }

    protected void fireExtraDatePickAction() {
        this.showDatePicker();
    }

    @Override
    protected Document createDefaultModel() {
        return new DateDocument(this);
    }

    @Override
    public DateDocument getDocument() {
        return (DateDocument)super.getDocument();
    }

    protected void addClickAction() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && EDateField.this.isEnabled() && EDateField.this.isEditable()) {
                    EDateField.this.showDatePicker();
                }
            }
        });
    }

    public void showDatePicker() {
        EDatePicker datePicker = EDatePicker.getSingleInstance(this, this.getDocument().getPattern(), this.getDate());
        datePicker.showWindow();
    }

    public void setTextEx(String value) {
        String pattern = this.getDocument().getPattern();
        if (pattern.indexOf("HH") != -1) {
            String oldValue = this.getText();
            if (oldValue.length() > 9) {
                value = String.valueOf(value.substring(0, 10)) + oldValue.substring(10);
            }
            this.setText(value);
        } else {
            this.setText(value);
        }
    }

    public Date getDate() {
        String dateStr = this.getText();
        if (dateStr.length() == 0) {
            return null;
        }
        try {
            Date d = new SimpleDateFormat(this.getDocument().getPattern()).parse(dateStr);
            return d;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f\uff1a" + this.getDocument().getPattern());
        }
    }

    public void addDays(int days) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.getDate());
        gc.add(6, days);
        this.setDate(gc.getTime());
    }

    public void setHourAndMinute(int hour, int minute) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.getDate());
        gc.set(11, hour);
        gc.set(12, minute);
        this.setDate(gc.getTime());
    }

    public void setDate(Date d) {
        if (d == null) {
            this.setText(null);
        } else {
            this.setText(new SimpleDateFormat(this.getDocument().getPattern()).format(d));
        }
    }

    @Override
    public void setDocument(Document doc) {
        try {
            super.setDocument((DateDocument)doc);
            this.setInputVerifier(new ValidVerifier());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inputOK() {
        try {
            int hour;
            int day;
            int month;
            int year;
            int indx;
            String pattern;
            String txt;
            block10: {
                txt = this.getText();
                if (txt.length() == 0) {
                    return true;
                }
                pattern = this.getDocument().getPattern();
                StringBuffer pb = new StringBuffer(pattern);
                int i = 0;
                while (true) {
                    if (i >= pb.length()) {
                        pattern = pb.toString();
                        indx = -1;
                        year = -1;
                        month = -1;
                        indx = pattern.indexOf("yyyy");
                        if (indx == -1) break;
                        year = Integer.parseInt(txt.substring(indx, indx + 4));
                        if (year < 1900) {
                            this.setCaretPosition(indx);
                            return false;
                        }
                        break block10;
                    }
                    if (pattern.charAt(i) == '\'') {
                        pb.deleteCharAt(i);
                        --i;
                    }
                    ++i;
                }
                year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
            }
            if ((indx = pattern.indexOf("MM")) != -1 && (month = Integer.parseInt(txt.substring(indx, indx + 2))) > 12) {
                this.setCaretPosition(indx);
                return false;
            }
            indx = pattern.indexOf("dd");
            if (indx != -1 && (day = Integer.parseInt(txt.substring(indx, indx + 2))) > ChineseCalendar.iGetSYearMonthDays(year, month)) {
                this.setCaretPosition(indx);
                return false;
            }
            indx = pattern.indexOf("HH");
            if (indx != -1 && (hour = Integer.parseInt(txt.substring(indx, indx + 2))) > 23) {
                this.setCaretPosition(indx);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public EDateField setLabelCom(JComponent labelCom) {
        this.labelCom = labelCom;
        return this;
    }

    public JComponent getLabelCom() {
        return this.labelCom;
    }
}

