/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.EOptionPane;
import com.eva.epc.widget.HardLayoutPane;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ECoupleSelectPane
extends JPanel {
    private DefaultListModel srcListModel = new DefaultListModel();
    private DefaultListModel destListModel = new DefaultListModel();
    private JList srcList = new JList(this.srcListModel);
    private JList destList = new JList(this.destListModel);
    private JButton btnAdd = new JButton("", IconFactory.getInstance().getArrowRightIcon_16_16());
    private JButton btnAddAll = new JButton("", IconFactory.getInstance().getArrowRightAllIcon_16_16());
    private JButton btnRemove = new JButton("", IconFactory.getInstance().getArrowLeftIcon_16_16());
    private JButton btnRemoveAll = new JButton("", IconFactory.getInstance().getArrowLeftAllIcon_16_16());
    private String srcListShow;
    private String destListShow;
    private JPanel srcPane;
    private JPanel destPane;
    private HardLayoutPane btnPane;
    private boolean exclude = false;
    private JTextField txtLeftQuery = new JTextField(10);
    private JTextField txtRightQuery = new JTextField(10);

    public ECoupleSelectPane() {
        this(false, new Vector(0), new Vector(0), "", "");
    }

    public ECoupleSelectPane(Vector allListData, Vector selectedListData, String sourceListName, String destineListName) {
        this(false, allListData, selectedListData, sourceListName, destineListName);
    }

    public ECoupleSelectPane(boolean exclude, Vector allListData, Vector selectedListData, String soureceListName, String destineListName) {
        this.exclude = exclude;
        allListData = (Vector)allListData.clone();
        selectedListData = (Vector)selectedListData.clone();
        if (exclude) {
            selectedListData.retainAll(allListData);
            allListData.removeAll(selectedListData);
        }
        for (Object e : allListData) {
            this.srcListModel.addElement(e);
        }
        for (Object e : selectedListData) {
            this.destListModel.addElement(e);
        }
        this.setSrcListShow(soureceListName);
        this.setDestListShow(destineListName);
        this.initGUI();
        this.addListenerForBtns();
        this.addListenersForList();
        this.disableSingleOperation();
    }

    private void initGUI() {
        this.btnAdd.setMargin(new Insets(5, 9, 5, 9));
        this.btnAddAll.setMargin(new Insets(5, 9, 5, 9));
        this.btnRemove.setMargin(new Insets(5, 9, 5, 9));
        this.btnRemoveAll.setMargin(new Insets(5, 9, 5, 9));
        this.btnPane = new HardLayoutPane();
        this.btnPane.addTo(this.btnAdd);
        this.btnPane.nextLine();
        this.btnPane.addTo(this.btnAddAll);
        this.btnPane.nextLine();
        this.btnPane.addTo(this.btnRemove);
        this.btnPane.nextLine();
        this.btnPane.addTo(this.btnRemoveAll);
        this.srcList.setFixedCellHeight(20);
        JScrollPane srcScrollPane = new JScrollPane(this.srcList);
        JPanel p = new JPanel(new BorderLayout());
        this.srcPane = new JPanel(new BorderLayout());
        this.srcPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.srcListShow));
        this.txtLeftQuery.setMargin(new Insets(0, 0, 0, 0));
        p.add((Component)this.txtLeftQuery, "Center");
        p.add((Component)this.createFintBtn(new FindActionImpl(this.srcList, this.txtLeftQuery, srcScrollPane)), "East");
        this.srcPane.add(srcScrollPane);
        this.srcPane.add((Component)p, "North");
        this.destList.setFixedCellHeight(20);
        JScrollPane destScrollPane = new JScrollPane(this.destList);
        this.destPane = new JPanel(new BorderLayout());
        this.destPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.destListShow));
        JPanel p2 = new JPanel(new BorderLayout());
        this.txtRightQuery.setMargin(new Insets(0, 0, 0, 0));
        p2.add((Component)this.txtRightQuery, "Center");
        p2.add((Component)this.createFintBtn(new FindActionImpl(this.destList, this.txtRightQuery, destScrollPane)), "East");
        this.destPane.add((Component)destScrollPane, "Center");
        this.destPane.add((Component)p2, "North");
        this.setLayout(new ThisLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.add(this.srcPane);
        this.add(this.btnPane.getFixedSubPane());
        this.add(this.destPane);
    }

    private JButton createFintBtn(Action a) {
        JButton findBtn1 = SwingUtils.getPicsButton(null, IconFactory.getInstance().getQueryBtnIconRIghtUnrover_16_16(), a);
        findBtn1.setRolloverIcon(IconFactory.getInstance().getQueryBtnIconRIghtRover_16_16());
        findBtn1.setContentAreaFilled(false);
        findBtn1.setMargin(new Insets(0, 0, 0, 0));
        findBtn1.setBorder(null);
        findBtn1.setBorderPainted(false);
        findBtn1.setToolTipText("\u70b9\u51fb\u67e5\u627e.");
        return findBtn1;
    }

    protected void addListenerForBtns() {
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ECoupleSelectPane.this.fireAdd();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ECoupleSelectPane.this.fireRemove();
            }
        });
        this.btnAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ECoupleSelectPane.this.fireAddAll();
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ECoupleSelectPane.this.fireRemoveAll();
            }
        });
    }

    protected void addListenersForList() {
        this.srcList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ECoupleSelectPane.this.fireAdd();
                }
            }
        });
        this.destList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ECoupleSelectPane.this.fireRemove();
                }
            }
        });
        this.destList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ECoupleSelectPane.this.btnRemove.setEnabled(ECoupleSelectPane.this.destList.getSelectedValue() != null);
            }
        });
        this.srcList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ECoupleSelectPane.this.srcList.getSelectedValue() != null) {
                    ECoupleSelectPane.this.btnAdd.setEnabled(true);
                }
            }
        });
    }

    private void fireAdd() {
        int autoIndex;
        int[] ids = this.srcList.getSelectedIndices();
        if (ids != null) {
            this.btnAdd.setEnabled(false);
            int i = 0;
            while (i < ids.length) {
                Object item = this.srcListModel.getElementAt(ids[i] - i);
                this.addObject(item);
                if (this.exclude) {
                    this.srcListModel.removeElement(item);
                }
                ++i;
            }
        }
        if (ids.length > 0 && (autoIndex = ids[ids.length - 1] + 1 - ids.length) > -1 && autoIndex < this.srcListModel.size()) {
            this.srcList.setSelectedIndex(autoIndex);
        }
        if (this.srcListModel.size() == 0) {
            this.btnAddAll.setEnabled(false);
        }
        this.btnRemove.setEnabled(false);
        this.btnRemoveAll.setEnabled(true);
    }

    private void fireRemove() {
        int[] ids = this.destList.getSelectedIndices();
        if (ids != null) {
            int autoIndex;
            this.btnRemove.setEnabled(false);
            int i = 0;
            while (i < ids.length) {
                Object item = this.destListModel.remove(ids[i] - i);
                if (this.exclude) {
                    this.srcListModel.addElement(item);
                }
                ++i;
            }
            if (ids.length > 0 && (autoIndex = ids[ids.length - 1] + 1 - ids.length) > -1 && autoIndex < this.destListModel.size()) {
                this.destList.setSelectedIndex(autoIndex);
            }
        }
        if (this.destListModel.size() == 0) {
            this.btnRemoveAll.setEnabled(false);
        }
        this.btnAdd.setEnabled(false);
        this.btnAddAll.setEnabled(true);
    }

    private void disableSingleOperation() {
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnAddAll.setEnabled(this.srcListModel.size() != 0);
        this.btnRemoveAll.setEnabled(this.destListModel.size() != 0);
    }

    public void addObject(Object item) {
        if (!this.destListModel.contains(item) && this.srcListModel.contains(item)) {
            this.destListModel.addElement(item);
            this.srcListModel.removeElement(item);
        }
    }

    public void removeObject(Object item) {
        if (this.destListModel.contains(item) && !this.srcListModel.contains(item)) {
            this.destListModel.removeElement(item);
            this.srcListModel.addElement(item);
        }
    }

    public void fireAddAll() {
        int n = this.srcListModel.size();
        int i = n - 1;
        while (i >= 0) {
            Object item = this.srcListModel.getElementAt(i);
            this.addObject(item);
            if (this.exclude) {
                this.srcListModel.removeElement(item);
            }
            --i;
        }
        this.btnAddAll.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemoveAll.setEnabled(true);
    }

    public void fireRemoveAll() {
        int n = this.destListModel.size();
        int i = n - 1;
        while (i >= 0) {
            Object item = this.destListModel.remove(i);
            if (this.exclude) {
                this.srcListModel.addElement(item);
            }
            --i;
        }
        this.btnRemoveAll.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnAddAll.setEnabled(true);
    }

    public Vector getDestListDatas() {
        Vector destListDatas = new Vector();
        int i = 0;
        while (i < this.destListModel.size()) {
            Object item = this.destListModel.getElementAt(i);
            destListDatas.addElement(item);
            ++i;
        }
        return destListDatas;
    }

    public Vector getSrcDatas() {
        Vector srcDatas = new Vector();
        int i = 0;
        while (i < this.srcListModel.size()) {
            Object item = this.srcListModel.getElementAt(i);
            srcDatas.addElement(item);
            ++i;
        }
        return srcDatas;
    }

    public void setDestDatas(Vector destNewDatas) {
        destNewDatas = (Vector)destNewDatas.clone();
        Vector srcOriginalDatas = this.getSrcDatas();
        if (this.exclude) {
            destNewDatas.retainAll(srcOriginalDatas);
            srcOriginalDatas.removeAll(destNewDatas);
            this.srcListModel.removeAllElements();
            for (Object e : srcOriginalDatas) {
                this.srcListModel.addElement(e);
            }
        }
        this.destListModel.removeAllElements();
        for (Object e : destNewDatas) {
            this.destListModel.addElement(e);
        }
        this.disableSingleOperation();
    }

    public void setSrcDatas(Vector srcNewDatas) {
        srcNewDatas = (Vector)srcNewDatas.clone();
        Vector destOriginalDatas = this.getDestListDatas();
        if (this.exclude) {
            destOriginalDatas.retainAll(srcNewDatas);
            srcNewDatas.removeAll(destOriginalDatas);
            this.destListModel.removeAllElements();
            for (Object e : destOriginalDatas) {
                this.destListModel.addElement(e);
            }
        }
        this.srcListModel.removeAllElements();
        for (Object e : srcNewDatas) {
            this.srcListModel.addElement(e);
        }
        this.disableSingleOperation();
    }

    public void setSrcListShow(String srcListShow) {
        this.srcListShow = srcListShow;
    }

    public void setDestListShow(String destListShow) {
        this.destListShow = destListShow;
    }

    public JList getSrcList() {
        return this.srcList;
    }

    public JList getDestList() {
        return this.destList;
    }

    public static class FindActionImpl
    extends AbstractAction {
        protected JList theList;
        protected JTextField txtFind;
        protected int findedIndex = -1;
        protected JScrollPane theScrollOfList;
        protected String currentFindingText = null;

        public FindActionImpl(JList theList, JTextField txtFind, JScrollPane theScrollOfList) {
            super("", null);
            this.theList = theList;
            this.txtFind = txtFind;
            this.theScrollOfList = theScrollOfList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.currentFindingText == null) {
                this.findedIndex = -1;
                this.currentFindingText = this.txtFind.getText();
            } else if (!this.currentFindingText.equals(this.txtFind.getText())) {
                this.findedIndex = -1;
                this.currentFindingText = this.txtFind.getText();
            }
            this.findedIndex = FindActionImpl.findText(this.theList.getModel(), this.currentFindingText, this.findedIndex);
            if (this.findedIndex != -1) {
                this.theList.setSelectedIndex(this.findedIndex);
                int height = this.theList.getHeight();
                int rowHeight = height / this.theList.getModel().getSize();
                this.theList.scrollRectToVisible(new Rectangle(0, rowHeight * this.findedIndex, this.theScrollOfList.getWidth(), this.theScrollOfList.getHeight() / 2));
            } else {
                EOptionPane.showInfoDialog(JOptionPane.getRootFrame(), "\u53cb\u60c5\u63d0\u793a", "\u6ca1\u6709\u627e\u5230\u66f4\u591a\u7684\u67e5\u8be2\u7ed3\u679c.");
            }
        }

        private static int findText(ListModel model, String text, int index) {
            boolean find = false;
            int i = index == -1 ? 0 : index + 1;
            while (i < model.getSize() && !find) {
                find = model.getElementAt(i).toString().indexOf(text) != -1;
                ++i;
            }
            if (find) {
                return --i;
            }
            return -1;
        }
    }

    class ThisLayout
    implements LayoutManager {
        ThisLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public void addLayoutComponent(String s, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void layoutContainer(Container c) {
            int operationBtnPaneWidth = 50;
            Rectangle b = c.getBounds();
            int leftAndRightAverageWidth = (b.width - operationBtnPaneWidth) / 2;
            ECoupleSelectPane.this.srcPane.setBounds(0, 0, leftAndRightAverageWidth, b.height);
            ECoupleSelectPane.this.btnPane.getFixedSubPane().setBounds(leftAndRightAverageWidth, 0, operationBtnPaneWidth, b.height);
            ECoupleSelectPane.this.destPane.setBounds(operationBtnPaneWidth + leftAndRightAverageWidth, 0, leftAndRightAverageWidth, b.height);
        }
    }
}

