/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.util.SwingUtils;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class EAction
extends AbstractAction {
    public EAction() {
    }

    public EAction(String text) {
        this.setText(text);
    }

    public EAction(String text, Icon icon) {
        this.setText(text);
        this.setIcon(icon);
    }

    public EAction setTooltip(String txt) {
        super.putValue("ShortDescription", txt);
        return this;
    }

    public EAction setText(String text) {
        int[] mn = new int[1];
        text = SwingUtils.parseTextFromMemonicText(text, mn);
        this.setMnemonic(mn[0]);
        super.putValue("Name", text);
        return this;
    }

    public EAction setMnemonic(int mnemonic) {
        super.putValue("MnemonicKey", mnemonic <= 0 ? null : new Integer(mnemonic));
        return this;
    }

    public EAction setIcon(Icon icon) {
        super.putValue("SmallIcon", icon);
        return this;
    }

    public EAction setAccelerator(KeyStroke key) {
        super.putValue("AcceleratorKey", key);
        return this;
    }

    public String getText() {
        String name = (String)this.getValue("Name");
        if (name != null) {
            name = SwingUtils.parseTextFromMemonicText(name, new int[1]);
        }
        return name;
    }
}

