/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableColumnExt
extends TableColumn {
    protected boolean visible = true;
    protected Object prototypeValue;
    protected boolean editable = true;
    private String toolTipText;
    protected Hashtable<Object, Object> clientProperties;

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int modelIndex) {
        this(modelIndex, 75);
    }

    public TableColumnExt(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumnExt(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(modelIndex, width, cellRenderer, cellEditor);
    }

    public TableColumnExt(TableColumnExt columnExt) {
        this(columnExt.getModelIndex(), columnExt.getWidth(), columnExt.getCellRenderer(), columnExt.getCellEditor());
        this.copyFrom(columnExt);
    }

    @Override
    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean editable) {
        boolean oldEditable = this.editable;
        this.editable = editable;
        this.firePropertyChange("editable", oldEditable, editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object value) {
        Object oldPrototypeValue = this.prototypeValue;
        this.prototypeValue = value;
        this.firePropertyChange("prototypeValue", oldPrototypeValue, value);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setToolTipText(String toolTipText) {
        String old = this.getToolTipText();
        this.toolTipText = toolTipText;
        this.firePropertyChange("toolTipText", old, this.getToolTipText());
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setTitle(String title) {
        this.setHeaderValue(title);
    }

    public String getTitle() {
        Object header = this.getHeaderValue();
        return header != null ? header.toString() : null;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldVisible, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null && this.getClientProperty(key) == null) {
            return;
        }
        Object old = this.getClientProperty(key);
        if (value == null) {
            this.getClientProperties().remove(key);
        } else {
            this.getClientProperties().put(key, value);
        }
        this.firePropertyChange(key.toString(), old, value);
    }

    public Object getClientProperty(Object key) {
        return key == null || this.clientProperties == null ? null : this.clientProperties.get(key);
    }

    private Hashtable<Object, Object> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    protected void copyFrom(TableColumnExt original) {
        this.setEditable(original.isEditable());
        this.setHeaderValue(original.getHeaderValue());
        this.setToolTipText(original.getToolTipText());
        this.setIdentifier(original.getIdentifier());
        this.setMaxWidth(original.getMaxWidth());
        this.setMinWidth(original.getMinWidth());
        this.setPreferredWidth(original.getPreferredWidth());
        this.setPrototypeValue(original.getPrototypeValue());
        this.setResizable(original.isResizable);
        this.setVisible(original.isVisible());
        this.copyClientPropertiesFrom(original);
    }

    protected void copyClientPropertiesFrom(TableColumnExt original) {
        if (original.clientProperties == null) {
            return;
        }
        for (Object key : original.clientProperties.keySet()) {
            this.putClientProperty(key, original.getClientProperty(key));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] pcl;
        if ((oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) && (pcl = this.getPropertyChangeListeners()) != null && pcl.length != 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            int i = 0;
            while (i < pcl.length) {
                pcl[i].propertyChange(pce);
                ++i;
            }
        }
    }
}

