/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.search;

import com.eva.epc.swingx.search.AbstractSearchable;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;

public class TableSearchable
extends AbstractSearchable {
    protected JTable table;

    public TableSearchable(JTable table) {
        this.table = table;
    }

    @Override
    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult matchRow = null;
        if (backwards) {
            int r = startRow;
            while (r >= -1 && matchRow == null) {
                matchRow = this.findMatchBackwardsInRow(pattern, r);
                this.updateState(matchRow);
                --r;
            }
        } else {
            int r = startRow;
            while (r <= this.getSize() && matchRow == null) {
                matchRow = this.findMatchForwardInRow(pattern, r);
                this.updateState(matchRow);
                ++r;
            }
        }
    }

    @Override
    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
    }

    private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            int column = startColumn;
            while (column < this.table.getColumnCount()) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result != null) {
                    return result;
                }
                ++column;
            }
        }
        return null;
    }

    private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? this.table.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            int column = startColumn;
            while (column >= 0) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result != null) {
                    return result;
                }
                --column;
            }
        }
        return null;
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column) {
        Matcher matcher;
        String text = (String)this.table.getValueAt(row, column);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, column);
        }
        return null;
    }

    @Override
    protected int adjustStartPosition(int startIndex, boolean backwards) {
        this.lastSearchResult.foundColumn = -1;
        return super.adjustStartPosition(startIndex, backwards);
    }

    @Override
    protected int moveStartPosition(int startRow, boolean backwards) {
        if (backwards) {
            --this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn < 0) {
                --startRow;
            }
        } else {
            ++this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn >= this.table.getColumnCount()) {
                this.lastSearchResult.foundColumn = -1;
                ++startRow;
            }
        }
        return startRow;
    }

    @Override
    protected boolean isEqualStartIndex(int startIndex) {
        return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
    }

    private boolean isValidColumn(int column) {
        return column >= 0 && column < this.table.getColumnCount();
    }

    @Override
    protected int getSize() {
        return this.table.getRowCount();
    }

    @Override
    public JTable getTarget() {
        return this.table;
    }

    @Override
    protected int convertColumnIndexToModel(int viewColumn) {
        return this.getTarget().convertColumnIndexToModel(viewColumn);
    }

    protected void moveMatchBySelection() {
        Rectangle cellRect;
        if (!this.hasMatch()) {
            return;
        }
        int row = this.lastSearchResult.foundRow;
        int column = this.lastSearchResult.foundColumn;
        this.table.changeSelection(row, column, false, false);
        if (!this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, column, true)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    @Override
    protected void moveMatchMarker() {
        this.moveMatchBySelection();
    }
}

