/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.search;

import com.eva.epc.swingx.JXDialog;
import com.eva.epc.swingx.JXFindPanel;
import com.eva.epc.swingx.search.Searchable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SearchFactory {
    private static SearchFactory searchFactory;
    protected JXFindPanel findPanel;
    protected JComponent lastFindBarTarget;
    private Point lastFindDialogLocation;
    private FindRemover findRemover;

    public static SearchFactory getInstance() {
        if (searchFactory == null) {
            searchFactory = new SearchFactory();
        }
        return searchFactory;
    }

    public static void setInstance(SearchFactory factory) {
        searchFactory = factory;
    }

    public KeyStroke getSearchAccelerator() {
        return KeyStroke.getKeyStroke("control F");
    }

    public void showFindInput(JComponent target, Searchable searchable) {
        this.showFindDialog(target, searchable);
    }

    protected void installFindRemover(Container target, Container findWidget) {
        if (target != null) {
            this.getFindRemover().addTarget(target);
        }
        this.getFindRemover().addTarget(findWidget);
    }

    private FindRemover getFindRemover() {
        if (this.findRemover == null) {
            this.findRemover = new FindRemover();
        }
        return this.findRemover;
    }

    protected void removeFromParent(JComponent component) {
        Container oldParent = component.getParent();
        if (oldParent != null) {
            oldParent.remove(component);
            if (oldParent instanceof JComponent) {
                ((JComponent)oldParent).revalidate();
            } else {
                oldParent.invalidate();
                oldParent.validate();
            }
        }
    }

    protected void stopSearching() {
        if (this.findPanel != null) {
            this.lastFindDialogLocation = this.hideSharedFindPanel(false);
            this.findPanel.setSearchable(null);
        }
    }

    public void showFindDialog(JComponent target, Searchable searchable) {
        JXDialog findDialog;
        JXDialog topLevel;
        Window frame = null;
        if (target != null) {
            frame = SwingUtilities.getWindowAncestor(target);
        }
        if ((topLevel = this.getDialogForSharedFindPanel()) != null && topLevel.getOwner().equals(frame)) {
            findDialog = topLevel;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(findDialog);
        } else {
            Point location = this.hideSharedFindPanel(true);
            findDialog = frame instanceof Frame ? new JXDialog((Frame)frame, (JComponent)this.getSharedFindPanel()) : (frame instanceof Dialog ? new JXDialog((Dialog)frame, (JComponent)this.getSharedFindPanel()) : new JXDialog(JOptionPane.getRootFrame(), (JComponent)this.getSharedFindPanel()));
            findDialog.pack();
            if (location == null) {
                findDialog.setLocationRelativeTo(frame);
            } else {
                findDialog.setLocation(location);
            }
        }
        if (target != null) {
            findDialog.setLocale(target.getLocale());
        }
        this.getSharedFindPanel().setSearchable(searchable);
        this.installFindRemover(target, findDialog);
        findDialog.setVisible(true);
    }

    public JXFindPanel getSharedFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
            this.configureSharedFindPanel();
        }
        return this.findPanel;
    }

    public JXFindPanel createFindPanel() {
        return new JXFindPanel();
    }

    protected void configureSharedFindPanel() {
    }

    private JXDialog getDialogForSharedFindPanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        return window instanceof JXDialog ? (JXDialog)window : null;
    }

    public Point hideSharedFindPanel(boolean dispose) {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        Point location = this.lastFindDialogLocation;
        if (window != null) {
            if (window.isVisible()) {
                location = window.getLocationOnScreen();
                window.setVisible(false);
            }
            if (dispose) {
                this.findPanel.getParent().remove(this.findPanel);
                window.dispose();
            }
        }
        return location;
    }

    public class FindRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        Set<Container> targets;

        public FindRemover() {
            this.updateManager();
        }

        public void addTarget(Container target) {
            this.getTargets().add(target);
        }

        public void removeTarget(Container target) {
            this.getTargets().remove(target);
        }

        private Set<Container> getTargets() {
            if (this.targets == null) {
                this.targets = new HashSet<Container>();
            }
            return this.targets;
        }

        private void updateManager() {
            if (this.focusManager != null) {
                this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Component c = this.focusManager.getPermanentFocusOwner();
            if (c == null) {
                return;
            }
            for (Container element : this.getTargets()) {
                if (element != c && !SwingUtilities.isDescendingFrom(c, element)) continue;
                return;
            }
            this.endSearching();
        }

        public void endSearching() {
            this.getTargets().clear();
            SearchFactory.this.stopSearching();
        }
    }
}

