/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PatternModel {
    public static final String SEARCH_PREFIX = "Search.";
    public static final String REGEX_UNCHANGED = "regex";
    public static final String REGEX_ANCHORED = "anchored";
    public static final String REGEX_WILDCARD = "wildcard";
    public static final String REGEX_MATCH_RULES = "explicit";
    public static final String MATCH_RULE_CONTAINS = "contains";
    public static final String MATCH_RULE_EQUALS = "equals";
    public static final String MATCH_RULE_ENDSWITH = "endsWith";
    public static final String MATCH_RULE_STARTSWITH = "startsWith";
    public static final String MATCH_BACKWARDS_ACTION_COMMAND = "\u7cbe\u786e\u5230\u5217";
    public static final String MATCH_WRAP_ACTION_COMMAND = "\u5faa\u73af\u67e5\u627e";
    public static final String MATCH_CASE_ACTION_COMMAND = "\u533a\u5206\u5927\u5c0f\u5199";
    public static final String MATCH_INCREMENTAL_ACTION_COMMAND = "matchIncremental";
    private String rawText;
    private boolean backwards;
    private Pattern pattern;
    private int foundIndex = -1;
    private boolean caseSensitive;
    private PropertyChangeSupport propertySupport;
    private String regexCreatorKey;
    private RegexCreator regexCreator;
    private boolean wrapping;
    private boolean incremental;

    public int getFoundIndex() {
        return this.foundIndex;
    }

    public void setFoundIndex(int foundIndex) {
        int old = this.getFoundIndex();
        this.updateFoundIndex(foundIndex);
        this.firePropertyChange("foundIndex", old, this.getFoundIndex());
    }

    protected void updateFoundIndex(int newFoundIndex) {
        if (newFoundIndex < 0) {
            this.foundIndex = newFoundIndex;
            return;
        }
        this.foundIndex = this.isAutoAdjustFoundIndex() ? (this.backwards ? newFoundIndex - 1 : newFoundIndex + 1) : newFoundIndex;
    }

    public boolean isAutoAdjustFoundIndex() {
        return !this.isIncremental();
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public void setBackwards(boolean backwards) {
        boolean old = this.isBackwards();
        this.backwards = backwards;
        this.firePropertyChange("backwards", old, this.isBackwards());
        this.setFoundIndex(this.getFoundIndex());
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean wrapping) {
        boolean old = this.isWrapping();
        this.wrapping = wrapping;
        this.firePropertyChange("wrapping", old, this.isWrapping());
    }

    public void setIncremental(boolean incremental) {
        boolean old = this.isIncremental();
        this.incremental = incremental;
        this.firePropertyChange("incremental", old, this.isIncremental());
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        boolean old = this.isCaseSensitive();
        this.caseSensitive = caseSensitive;
        this.updatePattern(caseSensitive);
        this.firePropertyChange("caseSensitive", old, this.isCaseSensitive());
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String findText) {
        String old = this.getRawText();
        boolean oldEmpty = this.isEmpty();
        this.rawText = findText;
        this.updatePattern(this.createRegEx(findText));
        this.firePropertyChange("rawText", old, this.getRawText());
        this.firePropertyChange("empty", oldEmpty, this.isEmpty());
    }

    public boolean isEmpty() {
        return this.isEmpty(this.getRawText());
    }

    private String createRegEx(String searchString) {
        if (this.isEmpty(searchString)) {
            return null;
        }
        return this.getRegexCreator().createRegEx(searchString);
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    private void updatePattern(String regEx) {
        Pattern old = this.getPattern();
        if (this.isEmpty(regEx)) {
            this.pattern = null;
        } else if (old == null || !old.pattern().equals(regEx)) {
            this.pattern = Pattern.compile(regEx, this.getFlags());
        }
        this.firePropertyChange("pattern", old, this.getPattern());
    }

    private int getFlags() {
        return this.isCaseSensitive() ? 0 : this.getCaseInsensitiveFlag();
    }

    private int getCaseInsensitiveFlag() {
        return 66;
    }

    private void updatePattern(boolean caseSensitive) {
        if (this.pattern == null) {
            return;
        }
        Pattern old = this.getPattern();
        int flags = old.flags();
        int flag = this.getCaseInsensitiveFlag();
        if (caseSensitive && (flags & flag) != 0) {
            this.pattern = Pattern.compile(this.pattern.pattern(), 0);
        } else if (!caseSensitive && (flags & flag) == 0) {
            this.pattern = Pattern.compile(this.pattern.pattern(), flag);
        }
        this.firePropertyChange("pattern", old, this.getPattern());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.firePropertyChange(name, oldValue, newValue);
    }

    public void setRegexCreatorKey(String mode) {
        if (this.getRegexCreatorKey().equals(mode)) {
            return;
        }
        String old = this.getRegexCreatorKey();
        this.regexCreatorKey = mode;
        this.createRegexCreator(this.getRegexCreatorKey());
        this.firePropertyChange("regexCreatorKey", old, this.getRegexCreatorKey());
    }

    protected void createRegexCreator(String mode) {
        if (REGEX_ANCHORED.equals(mode)) {
            this.setRegexCreator(new AnchoredSearchMode());
        } else {
            this.setRegexCreator(new RegexCreator());
        }
    }

    public String getRegexCreatorKey() {
        if (this.regexCreatorKey == null) {
            this.regexCreatorKey = this.getDefaultRegexCreatorKey();
        }
        return this.regexCreatorKey;
    }

    private String getDefaultRegexCreatorKey() {
        return REGEX_MATCH_RULES;
    }

    private RegexCreator getRegexCreator() {
        if (this.regexCreator == null) {
            this.regexCreator = new RegexCreator();
        }
        return this.regexCreator;
    }

    public void setRegexCreator(RegexCreator regexCreator) {
        RegexCreator old = this.regexCreator;
        this.regexCreator = regexCreator;
        this.firePropertyChange("regexCreator", old, regexCreator);
    }

    public void setMatchRule(String category) {
        if (this.getMatchRule().equals(category)) {
            return;
        }
        String old = this.getMatchRule();
        this.getRegexCreator().setMatchRule(category);
        this.updatePattern(this.createRegEx(this.getRawText()));
        this.firePropertyChange("matchRule", old, this.getMatchRule());
    }

    public String getMatchRule() {
        return this.getRegexCreator().getMatchRule();
    }

    public List<String> getMatchRules() {
        return this.getRegexCreator().getMatchRules();
    }

    public static class AnchoredSearchMode
    extends RegexCreator {
        @Override
        public boolean isAutoDetect() {
            return true;
        }

        @Override
        public String createRegEx(String searchExp) {
            if (this.isAutoDetect()) {
                StringBuffer buf = new StringBuffer(searchExp.length() + 4);
                if (!this.hasStartAnchor(searchExp) && this.isStartAnchored()) {
                    buf.append("^");
                }
                buf.append(searchExp);
                if (!this.hasEndAnchor(searchExp) && this.isEndAnchored()) {
                    buf.append("$");
                }
                return buf.toString();
            }
            return super.createRegEx(searchExp);
        }

        private boolean hasStartAnchor(String str) {
            return str.startsWith("^");
        }

        private boolean hasEndAnchor(String str) {
            int len = str.length();
            if (str.charAt(len - 1) != '$') {
                return false;
            }
            if (len == 1) {
                return true;
            }
            int n = len - 2;
            while (n >= 0) {
                if (str.charAt(n) != '\\') {
                    return (len - n) % 2 == 0;
                }
                --n;
            }
            return len % 2 != 0;
        }

        public boolean isStartAnchored() {
            return PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule()) || PatternModel.MATCH_RULE_STARTSWITH.equals(this.getMatchRule());
        }

        public boolean isEndAnchored() {
            return PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule()) || PatternModel.MATCH_RULE_ENDSWITH.equals(this.getMatchRule());
        }
    }

    public static class RegexCreator {
        protected String matchRule;
        private List<String> rules;

        public String getMatchRule() {
            if (this.matchRule == null) {
                this.matchRule = this.getDefaultMatchRule();
            }
            return this.matchRule;
        }

        public boolean isAutoDetect() {
            return false;
        }

        public String createRegEx(String searchString) {
            if (PatternModel.MATCH_RULE_CONTAINS.equals(this.getMatchRule())) {
                return this.createContainedRegEx(searchString);
            }
            if (PatternModel.MATCH_RULE_EQUALS.equals(this.getMatchRule())) {
                return this.createEqualsRegEx(searchString);
            }
            if (PatternModel.MATCH_RULE_STARTSWITH.equals(this.getMatchRule())) {
                return this.createStartsAnchoredRegEx(searchString);
            }
            if (PatternModel.MATCH_RULE_ENDSWITH.equals(this.getMatchRule())) {
                return this.createEndAnchoredRegEx(searchString);
            }
            return searchString;
        }

        protected String createEndAnchoredRegEx(String searchString) {
            return String.valueOf(Pattern.quote(searchString)) + "$";
        }

        protected String createStartsAnchoredRegEx(String searchString) {
            return "^" + Pattern.quote(searchString);
        }

        protected String createEqualsRegEx(String searchString) {
            return "^" + Pattern.quote(searchString) + "$";
        }

        protected String createContainedRegEx(String searchString) {
            return Pattern.quote(searchString);
        }

        public void setMatchRule(String category) {
            this.matchRule = category;
        }

        protected String getDefaultMatchRule() {
            return PatternModel.MATCH_RULE_CONTAINS;
        }

        public List<String> getMatchRules() {
            if (this.rules == null) {
                this.rules = this.createAndInitRules();
            }
            return this.rules;
        }

        private List<String> createAndInitRules() {
            if (!this.supportsRules()) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(PatternModel.MATCH_RULE_CONTAINS);
            list.add(PatternModel.MATCH_RULE_EQUALS);
            list.add(PatternModel.MATCH_RULE_STARTSWITH);
            list.add(PatternModel.MATCH_RULE_ENDSWITH);
            return list;
        }

        private boolean supportsRules() {
            return true;
        }
    }
}

